#
# Copyright (c) 2018. All rights reserved.
#
# This software and all trademarks, trade names, and logos included herein are the property of XebiaLabs, Inc. and its affiliates, subsidiaries, and licensors.
#

from xld.kubernetes.factories.handler_factory import ContainerHelperFactory
from xld.kubernetes.pod.pod_helper import PodHelper

container_helper = ContainerHelperFactory(deployed.container).create()

PodHelper.validate_pod(deployed_pod=deployed)

context.addStepWithCheckpoint(steps.jython(
    description="Create Pod {0} on {1} {2}".format(PodHelper.get_pod_name(deployed),
                                                   container_helper.get_container_label(),
                                                   container_helper.get_container_name(deployed.container)),
    script="xld/kubernetes/pod/create_pod.py",
    order=61
), delta)

context.addStepWithCheckpoint(steps.jython(
    description="Wait for Pod {0} to be in running state".format(PodHelper.get_pod_name(deployed)),
    script="xld/kubernetes/pod/wait_for_pod_creation.py",
    order=62
), delta)
