#
# Copyright (c) 2018. All rights reserved.
#
# This software and all trademarks, trade names, and logos included herein are the property of XebiaLabs, Inc. and its affiliates, subsidiaries, and licensors.
#
from xld.kubernetes.factories.handler_factory import ContainerHelperFactory, ResourceFactoryResolver
from xld.kubernetes.statefulset.statefulset_helper import StatefulSetHelper

result = "SUCCESS"
container_helper = ContainerHelperFactory(deployed.container).create()
provider = ResourceFactoryResolver(deployed).get_factory().get(data)
resources = provider.filter_resources_by_definition(namespace=container_helper.get_container_name(deployed.container),
                                                    resource_definition=data)

for statefulset in resources.items:
    if StatefulSetHelper.verify_stateful_set_ready_on_create(statefulset, data['metadata']['name'], 1):
        result = "RETRY"

