#
# Copyright (c) 2018. All rights reserved.
#
# This software and all trademarks, trade names, and logos included herein are the property of XebiaLabs, Inc. and its affiliates, subsidiaries, and licensors.
#

from kubernetes import client
from kubernetes.client.rest import ApiException
from xld.kubernetes import KubernetesBaseClient


class KubernetesStorageClient(KubernetesBaseClient):

    def __init__(self, container):
        super(KubernetesStorageClient, self).__init__(container)

    def get_storage_api(self):
        print ("[Using API version: {}]".format(self.get_api_version()))
        return client.StorageV1Api(self.internal_api_client)

    def get_api_version(self):
        return "storage.k8s.io/v1";

