#
# Copyright (c) 2018. All rights reserved.
#
# This software and all trademarks, trade names, and logos included herein are the property of XebiaLabs, Inc. and its affiliates, subsidiaries, and licensors.
#

from xld.kubernetes.config_map.helper import ConfigMapHelper
from xld.kubernetes.factories.handler_factory import ContainerHelperFactory

container_helper = ContainerHelperFactory(deployed.container).create()

context.addStepWithCheckpoint(steps.jython(
    description="Create ConfigMap {} on {}".format(ConfigMapHelper().get_config_map_name(deployed),
                                                    container_helper.get_container_name(deployed.container)),
    script="xld/kubernetes/config_map/create.py",
    order=59,
    preview_script="xld/kubernetes/config_map/preview.py"
), delta)

context.addStep(steps.jython(
    description="Wait for ConfigMap to be created",
    script="xld/kubernetes/config_map/wait_for_create.py",
    order=60
))
