#
# Copyright (c) 2018. All rights reserved.
#
# This software and all trademarks, trade names, and logos included herein are the property of XebiaLabs, Inc. and its affiliates, subsidiaries, and licensors.
#

import json
from org.apache.commons.io import IOUtils

import yaml
from xld.kubernetes.factories.handler_factory import ContainerHelperFactory
from xld.kubernetes.factories.handler_factory import ResourceFactoryResolver


class ResourceHelper(object):
    def __init__(self, deployed, context):
        self.__context = context
        self.__deployed = deployed
        self.__file_data = deployed.json if hasattr(deployed, 'json') and deployed.json else self.__get_data(deployed.file.getInputStream())
        self.__container_helper = ContainerHelperFactory(deployed.container).create()

    def parse(self):
        data = self.__file_data
        try:
            yaml_list = list(yaml.safe_load_all(data))
            items = []
            for item in yaml_list:

                # applying patches
                item_stream = yaml.safe_dump(item)

                modified_stream = self.__context.patch(item_stream, self.__deployed.deployable)
                patched_item = yaml.safe_load(modified_stream)

                if patched_item:
                    if patched_item['kind'] == 'List':
                        for sub_item in patched_item['items']:
                            items.append(sub_item)
                    else:
                        items.append(patched_item)
            return items, False
        except:
            try:
                # applying patches
                modified_str = self.__context.patch(data, self.__deployed.deployable)
                patched_json = json.loads(modified_str)

                return patched_json['items'] if patched_json['kind'] == 'List' else [patched_json], True
            except:
                raise

    @staticmethod
    def __get_data(filestream):
        try:
            data = IOUtils.toString(filestream, "UTF-8")
            return data
        finally:
            IOUtils.closeQuietly(filestream)

    def __get_error_msg(self, unsupported_resources):
        if bool(unsupported_resources):
            msg = "Unsupported resource {0} for {1} {2}".format(unsupported_resources[0],
                                                                self.__container_helper.get_container_label(),
                                                                self.__container_helper.get_container_name(
                                                                    self.__deployed.container))
        else:
            msg = "Unsupported resource for {0} {1}".format(self.__container_helper.get_container_label(),
                                                            self.__container_helper.get_container_name(
                                                                self.__deployed.container))
        return msg
