#
# Copyright (c) 2018. All rights reserved.
#
# This software and all trademarks, trade names, and logos included herein are the property of XebiaLabs, Inc. and its affiliates, subsidiaries, and licensors.
#

import importlib

from xld.kubernetes.resource.provider import DynamicResourceProvider


class K8SResourceFactory(object):
    def __init__(self, deployed):
        self.__deployed = deployed

    def get_resource_order(self):
        return {
            'Default': {'Create': self.__deployed.createOrder, 'Modify': self.__deployed.modifyOrder, 'Destroy': self.__deployed.destroyOrder}
        }

    @staticmethod
    def get_recreate_resources():
        return ['PersistentVolumeClaim']

    @staticmethod
    def get_resource_wait_details():
        return {
            "Create": {
                "Default": {'script': 'create_update_wait', 'action': "created"},
                "Pod": {'script': 'create_update_wait', 'action': "in running state"},
                "Deployment": {'script': 'deployment/create_update_wait', 'action': "in running state"},
                "StatefulSet": {'script': 'deployment/create_update_wait', 'action': "in running state"},
                "PersistentVolumeClaim": {'script': 'create_update_wait', 'action': "in Bound phase"}
            },
            "Destroy": {
                "Default": {'script': 'delete_wait', 'action': "destroyed completely"}
            },
            "Modify": {
                "Default": {'script': 'create_update_wait', 'action': "modified"},
                "Pod": {'script': 'create_update_wait', 'action': "in running state"},
                "Deployment": {'script': 'deployment/create_update_wait', 'action': "in running state"},
                "StatefulSet": {'script': 'deployment/create_update_wait', 'action': "in running state"}
            }
        }

    def get(self, data):
        return self._resolve(data)

    def _resolve(self, data):
        return DynamicResourceProvider(self.__deployed.container, data["kind"], data['apiVersion'] if 'apiVersion' in data else 'v1')

