#
# Copyright (c) 2018. All rights reserved.
#
# This software and all trademarks, trade names, and logos included herein are the property of XebiaLabs, Inc. and its affiliates, subsidiaries, and licensors.
#

from xld.kubernetes.factories.handler_factory import ContainerHelperFactory
from xld.kubernetes.secret.secret_helper import SecretHelper

container_helper = ContainerHelperFactory(deployed.container).create()

if previousDeployed and (SecretHelper().get_secret_name(previousDeployed) != SecretHelper().get_secret_name(deployed)):
    raise RuntimeError('Secret name should not be modified.')

order = deployed.modifyOrder if previousDeployed else deployed.createOrder
context.addStepWithCheckpoint(steps.jython(
    description="{0} Secret {1} on {2}".format(
        'Modify' if previousDeployed else 'Create', SecretHelper().get_secret_name(deployed),
        container_helper.get_container_name(deployed.container)),
    script="xld/kubernetes/secret/%s" % ('modify_secret.py' if previousDeployed else 'create_secret.py'),
    order=order
), delta)

# Wait step only for create secret
if not previousDeployed:
    context.addStep(steps.jython(
        description="Wait for Secret to be {0}".format("modified" if previousDeployed else "created"),
        script="xld/kubernetes/secret/wait_for_secret_creation.py",
        order=order + 1
    ))
