;(function(){

'use strict';

angular.module('xld.templates.environment', []).run(['$templateCache', function($templateCache) {

  $templateCache.put('environment/environments.html', '<div class="xl-deploy-space xl-environments"><xl-notify-view></xl-notify-view><div class="part detail"><div tab-view></div></div></div>');

  $templateCache.put('environment/tabs/environment/environment-ci-visual.html', '<div id="environment-visual-tab"><div class="xl-row"><div class="xl-column-main"><div class="xl-form-wrapper" ng-if="isLoaded()"><h4>{{ \'terminology.environmentTitle\' | i18n }}</h4><div class="xl-container xl-container-margin-top"><div class="input-component environment-name"><div class="input-label"><div xl-widget-label ng-model="$tabData.environmentData.environmentId" options="{label: \'Environment name\'}"></div></div><!--\n					---><div class="input-form">{{ $tabData.environmentId }}</div></div></div><div class="xl-container xl-container-margin-top"><div xl-dip-set-of-ci ng-model="$tabData.environmentData.members" metadata="{name: \'Containers\', label: \'Containers\'}" obj-label="id" display-mode="$tabData.mode" handlers="envContainersAutocompleteHandlers" open-on-click="true"></div></div><div class="xl-container xl-container-margin-top"><div xl-dip-set-of-ci ng-model="$tabData.environmentData.dictionaries" metadata="{name: \'Dictionaries\', label: \'Dictionaries\'}" obj-label="id" display-mode="$tabData.mode" handlers="envDictionariesAutocompleteHandlers" open-on-click="true"></div></div><h4>{{ \'terminology.advancedPropertiesTitle\' | i18n }}</h4><div xl-dip-dynamic-form ng-model="$tabData.environmentData" form-model="environmentDynamicFormModel" metadata="environmentMetadata" handlers="dipHandlers.formHandlers" display-mode="$tabData.mode"></div><div class="xl-button-container"><button id="editMode" class="xl-button xl-primary" ng-click="editEnvironment()" ng-if="false">{{ \'terminology.editButton\' | i18n }}</button></div></div></div><!--\n	---><div class="xl-column-aside" xl-sticky-parent><div class="xl-help-block" xl-sticky><h4>{{ \'terminology.helpTitle\' | i18n }}</h4><p>{{ \'terminology.environmentVisualHelpDescription\' | i18n }}</p></div></div></div></div>');

  $templateCache.put('environment/tabs/environment/environment-ci.html', '<div class="content" id="environment-tab"><div ng-if="$tabData.mode === \'visual\'"><div ng-include="\'environment/tabs/environment/environment-ci-visual.html\'"></div></div><div ng-if="$tabData.mode !== \'visual\'" xl-widget-wizard navigable="true" on-finish="" steps="$tabData.wizardStepsState"><div xl-wizard-step wz-title="{{\'terminology.nameEnvironmentTitle\' | i18n}}"><div class="environment-tab-content" ng-init="newEnvironmentForm= {}"><div class="xl-row"><div class="xl-column-main"><div ng-include="\'environment/tabs/environment/environment-wizard-steps/environment-ci-step-name-env.html\'"></div><div class="xl-button-container"><button close-ui-tab class="xl-button xl-cancel">{{ \'terminology.cancelButton\' | i18n }}</button> <button ng-click="verifyEnvNotExistAndGotoNextStep()" class="xl-button xl-primary" ng-disabled="environmentForms.envNameForm.$invalid">{{ \'terminology.nextButton\' | i18n }}</button></div></div><!--\n	  ---><div class="xl-column-aside" xl-sticky-parent><div class="xl-help-block" xl-sticky><h4>{{ \'terminology.helpTitle\' | i18n }}</h4><p>{{ \'terminology.environmentHelpDescription\' | i18n }}</p></div></div></div></div></div><div xl-wizard-step wz-title="{{\'terminology.setupContainerTitle\' | i18n}}"><div class="environment-tab-content"><div class="xl-row"><div class="xl-column-main"><div ng-include="\'environment/tabs/environment/environment-wizard-steps/environment-ci-step-set-container.html\'"></div><div class="xl-button-container"><button close-ui-tab class="xl-button xl-cancel">{{ \'terminology.cancelButton\' | i18n }}</button> <button xl-wizard-previous class="xl-button xl-secondary">{{ \'terminology.previousButton\' | i18n }}</button> <button id="next-container" ng-click="verifyContainerIsNotSelectAndGotoNextStep()" class="xl-button xl-primary">{{ \'terminology.nextButton\' | i18n }}</button></div></div><!--\n	  ---><div class="xl-column-aside" xl-sticky-parent><div class="xl-help-block" xl-sticky><h4>{{ \'terminology.helpTitle\' | i18n }}</h4><p>To add a new container to the environment:</p><ol><li>Click <strong>Add new container</strong>.</li><li>Select the container type. If the type depends on other container types, XL Deploy automatically adds them to the list of containers.</li><li>For each container in the list, choose whether you want to create a new container or select an existing one.</li><li>If you choose to create a new container, you will be asked to provide:<ul><li>A name for the container</li><li>Additional properties based on the configuration item type</li></ul></li><li>When you finish configuring the containers in the list, click <strong>Add to environment</strong>.</li></ol><p>To add an existing container to the environment:</p><ol><li>Click <strong>Select existing container</strong>.</li><li>Search for the container name or locate the container in the list.</li><li>Click the container name to add it to the environment.</li></ol><p>When you are finished adding containers to the environment, click <strong>Next</strong>.</p></div></div></div></div></div><div xl-wizard-step wz-title="{{\'terminology.setupDictionaryTitle\' | i18n}}"><div class="environment-tab-content"><div class="xl-row"><div class="xl-column-main"><div ng-include="\'environment/tabs/environment/environment-wizard-steps/environment-ci-step-set-dictionary.html\'"></div><div class="xl-button-container"><button close-ui-tab class="xl-button xl-cancel">{{ \'terminology.cancelButton\' | i18n }}</button> <button xl-wizard-previous class="xl-button xl-secondary">{{ \'terminology.previousButton\' | i18n }}</button> <button id="next-dico" ng-click="verifyDictonariesIsNotSelectAndGotoNextStep()" class="xl-button xl-primary">{{ \'terminology.nextButton\' | i18n }}</button></div></div><!--\n      ---><div class="xl-column-aside" xl-sticky-parent><div class="xl-help-block" xl-sticky><h4>{{ \'terminology.helpTitle\' | i18n }}</h4><p>To add a new dictionary to the environment:</p><ol><li>Click <strong>Add new dictionary</strong>.</li><li>Provide a name for the dictionary.</li><li>For each dictionary entry, provide a key and a value.</li><li>When you are finished adding entries to the dictionary, click <strong>Add to environment</strong>.</li></ol><p>To add an existing dictionary to the environment:</p><ol><li>Click <strong>Select existing dictionary</strong>.</li><li>Search for the dictionary name or locate the dictionary in the list.</li><li>Click the dictionary name to add it to the environment.</li></ol><p>When you are finished adding dictionaries to the environment, click <strong>Next</strong>.</p></div></div></div></div></div><div xl-wizard-step wz-title="{{\'terminology.advancedPropertiesTitle\' | i18n}}"><div class="environment-tab-content"><div class="xl-row"><div class="xl-column-main"><div ng-include="\'environment/tabs/environment/environment-wizard-steps/environment-ci-step-advanced-properties.html\'"></div><div class="xl-button-container"><button close-ui-tab class="xl-button xl-cancel">{{ \'terminology.cancelButton\' | i18n }}</button> <button xl-wizard-previous class="xl-button xl-secondary">{{ \'terminology.previousButton\' | i18n }}</button> <button value="Save" class="xl-button xl-primary" ng-click="saveEnvironment()" ng-disabled="environmentForms.environmentDynamicFormModel.$invalid">{{ \'terminology.saveButton\' | i18n }}</button></div></div><!--\n	  ---><div class="xl-column-aside" xl-sticky-parent><div class="xl-help-block" xl-sticky><p>You can optionally specify an SMTP server that XL Deploy can use to send an email notification when it reaches a manual process step in a deployment to this environment. A manual process step pauses the deployment so that you can take manual actions. After the manual actions are finished, you can resume the deployment.</p><strong>Triggers</strong><p>You can optionally use triggers to send email notifications for events that happen in this environment. For example, XL Deploy can send an email when a deployment to this environment completes successfully or when a step in the deployment plan fails. The email will be sent using the SMTP server that is assigned to the trigger. You can add multiple triggers to an environment.</p><p>Click <strong>Save</strong> to finish creating the environment.</p></div></div></div></div></div></div></div>');

  $templateCache.put('environment/tabs/welcome/welcome.html', '<div class="content" id="welcome-tab"><div class="xl-row"><div class="xl-column-main"><div class="description"><h4>{{ \'terminology.welcomeEnvironmentsMainTitle\' | i18n }}</h4><p>{{ \'terminology.welcomeEnvironmentsMainDescription\' | i18n }}</p><div class="question">{{ \'terminology.welcomeEnvironmentsMainQuestion\' | i18n }}<div id="new-environment" class="xl-button xl-secondary button-welcome svg-icon icon_add_environment" ng-click="vm.newEnvironment(\'\')">{{ \'terminology.createEnvironment\' | i18n }}</div></div></div></div><!--\n\n---><div class="xl-column-aside" xl-sticky-parent><div class="xl-help-block" xl-sticky><h4>{{ \'terminology.helpTitle\' | i18n }}</h4><p>An environment is a group of infrastructure and middleware containers such as hosts, application servers, web servers, and clusters. You can use these containers as targets when you deploy an application.</p><p>You can store data that is specific to an environment (such as user names and file paths) in a dictionary. Dictionaries are sets of key-value pairs that XL Deploy uses to replace placeholders that you insert in your deployment packages.</p><p>To create a new environment, click Create environment.</p></div></div></div></div>');

  $templateCache.put('environment/tabs/environment/container/container-modal.html', '<h4>{{ \'terminology.addNewContainerTitle\' | i18n:environmentId }}</h4><div class="scrollable"><div class="xl-form-wrapper wizard-step-name-env"><form name="containerNameForm.internal" id="new-env-name-form" class="form-horizontal" role="form"><div class="input-component"><div xl-widget-string ng-model="container.name" options="{label: \'Container name\', name: \'containerName\', required: true}"></div></div><!-- Type --><div class="input-component"><div class="input-label"><div xl-widget-label ng-model="container.type" options="{label: \'Container type\', required: true}"></div></div><!--\n            ---><div class="input-form"><div xl-widget-autocomplete-type="containerTypeNames" ng-model="container.type" on-select="onTypeSelect(type)" is-required="true" is-disabled="containerTypeNames.length === 1"></div></div></div><!-- Path --><div class="input-component" ng-show="typeDescriptor.root"><div class="input-label"><label for="container-path">{{ \'terminology.containerPath\' | i18n}}</label></div><!--\n            ---><div class="input-form"><div id="container-path" xl-widget-autocomplete ng-model="container.path" handlers="containerPathAutocompleteHandlers" select-mode="false" is-required="false"></div><span class="xl-field-description">{{ \'terminology.containerPathDescription\' | i18n}}</span></div></div></form><div xl-dip-dynamic-form ng-model="container" form-model="formModel" metadata="typeDescriptor" handlers="dipHandlers.formHandlers"></div><div class="xl-button-container"><button ng-click="close()" class="xl-button xl-cancel">{{ \'terminology.cancelButton\' | i18n}}</button> <button ng-click="create()" class="xl-button xl-primary" ng-disabled="!(!!containerNameForm.internal.$valid && !!formModel.$valid)">{{ \'terminology.createButton\' | i18n}}</button></div></div></div>');

  $templateCache.put('environment/tabs/environment/edit-dictionary-modal/edit-dictionary-modal.html', '<h4>{{ \'terminology.editDictionaryTitle\' | i18n:dictionary.id}}</h4><div class="scrollable"><div class="xl-form-wrapper"><form name="formEditDictionary.form"><div class="input-component"><div xl-dip-string ng-model="dictionary.id" metadata="{name: \'dictionaryId\', label: \'Dictionary name\', placeholder: \'\'}" display-mode="\'edition\'" is-disabled="true"></div><span class="xl-field-description">{{ \'terminology.dictionaryDescription\'}}</span><div id="xl-error" ng-show="postError" xl-widget-alert-message on-dismiss="postError=undefined">{{ postError }}</div></div><div class="input-label"><label>{{ \'terminology.entries\'}}</label></div><div class="map-dictionary" ng-if="dictionary.type === \'udm.EncryptedDictionary\'"><div xl-dip-map-string-string ng-model="dictionary.entries" entry="dictionary.inputEntry" metadata="{name: \'dictionaryEntries\', label: \'\', password: true}" display-mode="dictionary.mode"></div></div><div class="map-dictionary" ng-if="dictionary.type === \'udm.Dictionary\'"><div xl-dip-map-string-string ng-model="dictionary.entries" entry="dictionary.inputEntry" metadata="{name: \'dictionaryEntries\', label: \'\', password: false}" display-mode="dictionary.mode"></div><div class="input-label"><label>{{ \'terminology.encryptedEntries\'}}</label></div><div xl-dip-map-string-string ng-model="dictionary.encryptedEntries" entry="dictionary.encryptedInputEntry" metadata="{name: \'dictionaryEntries\', label: \'\', password: true}" display-mode="dictionary.mode"></div></div><div class="xl-button-container"><button ng-click="cancel()" class="xl-button xl-cancel">{{ \'terminology.cancelButton\'}}</button> <button ng-click="create()" class="save xl-button xl-primary" ng-disabled="!isValidDictionary()">{{ \'terminology.saveButton\'}}</button></div></form></div></div>');

  $templateCache.put('environment/tabs/environment/environment-wizard-steps/environment-ci-step-advanced-properties.html', '<div class="form-wrapper"><form name="environmentForms.environmentDynamicFormModel" id="new-env-advanced-properties-form" role="form"><div class="wizard-step-advanced-properties"><h4>{{ \'terminology.advancedPropertiesTitle\' | i18n}}</h4><div xl-dip-dynamic-form ng-model="$tabData.environmentData" form-model="environmentForms.environmentDynamicFormModel" metadata="environmentMetadata" handlers="dipHandlers.formHandlers" display-mode="$tabData.mode"></div></div></form></div>');

  $templateCache.put('environment/tabs/environment/environment-wizard-steps/environment-ci-step-name-env.html', '<div class="xl-form-wrapper wizard-step-name-env"><form name="environmentForms.envNameForm" id="new-env-name-form" class="form-horizontal" role="form"><div ng-switch on="$tabData.mode"><div ng-switch-when="creation"><h4>{{ \'terminology.nameEnvironmentTitle\' | i18n}}</h4><div>{{ \'terminology.nameEnvironmentDescription\' | i18n}}</div></div><h4 ng-switch-when="edition">{{ \'terminology.editEnvironmentTitle\' | i18n}}</h4><h4 ng-switch-default>{{ \'terminology.environmentTitle\' | i18n}}</h4></div><div class="xl-container xl-container-margin-top xl-container-top-triangle xl-container-top-triangle-10"><div class="input-component environment-name"><div class="input-label"><div xl-widget-label ng-model="$tabData.environmentData.environmentId" options="{label: \'Environment name\', required: true}"></div></div><!--\n    ---><div class="input-form"><div ng-show="$tabData.mode !== \'visual\'"><div xl-widget-string ng-model="$tabData.environmentId" options="{required:true}" handlers="envPathAutocompleteHandlers" select-mode="false"></div><span class="xl-field-description">{{ \'terminology.enterEnvironmentName\' | i18n}}</span></div><div ng-show="$tabData.mode===\'visual\'" for="environment-path">{{ $tabData.environmentId }}</div></div><div ng-show="$tabData.postEnvError" xl-widget-alert-message options="{indentForLabel: true}" on-dismiss="$tabData.postEnvError=undefined">{{ $tabData.postEnvError }}</div></div></div></form></div>');

  $templateCache.put('environment/tabs/environment/environment-wizard-steps/environment-ci-step-set-container.html', '<div class="xl-form-wrapper wizard-step-set-container"><form name="environmentForms.containerForm" id="new-env-set-container-form" role="form"><h4>{{ \'terminology.addToContainerTitle\' | i18n:$tabData.environmentId}}</h4><div>{{ \'terminology.addToContainerDescription\' | i18n}}</div><div class="xl-container xl-container-margin-top selected-containers"><div xl-dip-set-of-ci ng-model="$tabData.environmentData.members" metadata="{name: \'Containers\', label: \'Containers in environment\', required: false}" obj-label="id" display-mode="$tabData.mode" handlers="envContainersAutocompleteHandlers" new-item-suffix=" (New Container)" open-on-click="true" is-input-visible="false" empty-placeholder="No containers added yet"></div></div><div class="add-or-select-existing-block"><div class="input-component"><div class="input-label">addContainersLabel<label>{{ \'terminology.addContainersLabel\' | i18n}}</label></div><!--\n    ---><div class="input-form"><form><input type="radio" ng-model="$tabData.containerChoice" value="create">{{ \'terminology.addNewContainerField\' | i18n}}<br><input type="radio" ng-model="$tabData.containerChoice" value="existing">{{ \'terminology.selectExistingContainerField\' | i18n}}<br></form></div></div><div ng-if="$tabData.containerChoice===\'existing\'" class="container-existing xl-container xl-container-margin-top xl-container-top-triangle xl-container-top-triangle-33"><div xl-widget-item-selector handlers="existingContainersHandlers" ng-model="$tabData.environmentData.members" options="{ description : \'Add an existing container to the environment: \', multiple: true }" obj-label="id"></div></div><div ng-if="$tabData.containerChoice===\'create\'" class="container-new xl-container xl-container-margin-top xl-container-top-triangle xl-container-top-triangle-33"><div>{{ \'terminology.setUpNeContainerForEnvironment\' | i18n}}</div><!-- Type --><div class="input-component"><div class="input-label"><div xl-widget-label ng-model="$tabData.newContainerType" options="{label: \'Container type\'}"></div></div><!--\n      ---><div class="input-form"><div xl-widget-autocomplete-type="containerTypeNames" metadata="{name: \'containerTypes\'}" ng-model="$tabData.newContainerType" on-select="newContainerTypeSelected(type)" is-required="false" is-disabled="false"></div></div></div><!-- Container Hierarchy --><div class=""><div class="container-hierarchy-item" data-ng-repeat="containerBundle in $tabData.containerHierarchyBundles"><span class="container-order">{{$index+1}}.</span> <span ng-if="!containerBundle.displayButton()" class="container-title container-title-selected">{{containerBundle.getTitle().title}}</span> <span ng-if="containerBundle.displayButton()"><a href="#" class="inline-btn add" ng-click="createNewContainer(containerBundle)" ng-class="{\'disabledContainerBtn\': !containerBundle.activeButton()}"><span>{{ \'terminology.createNewLink\' | i18n}}</span></a> <span class="type-placeholder">or</span> <a href="#" class="inline-btn select" ng-click="selectExistingContainer(containerBundle)" ng-class="{\'disabledContainerBtn\': containerBundle.isNewContainer()}"><span>{{ \'terminology.selectExistingLink\' | i18n}}</span></a> <span ng-if="$index === 0" class="type-placeholder">{{ \'terminology.containerConnection\' | i18n:containerBundle.getTitle().title}}</span> <span ng-if="$index > 0" class="type-placeholder">{{containerBundle.getTitle().title}}</span> </span><span ng-if="!containerBundle.displayButton()"><a href="#" class="inline-btn cross" ng-click="containerBundle.clearContainerAndChild()"></span></div></div><div class="xl-button-container add-to-env"><button type="button" class="xl-button xl-primary" ng-click="addContainer()" ng-disabled="isValidContainer()">{{ \'terminology.addToEnvironmentButton\' | i18n}}</button></div></div></div></form></div>');

  $templateCache.put('environment/tabs/environment/environment-wizard-steps/environment-ci-step-set-dictionary.html', '<div class="xl-form-wrapper wizard-step-set-dictionaries"><h4>{{ \'terminology.setupDictionariesTitle\' | i18n:$tabData.environmentId}}</h4><div>{{ \'terminology.setupDictionariesDescription\' | i18n }}</div><div class="xl-container xl-container-margin-top selected-containers"><div xl-dip-set-of-ci ng-model="$tabData.environmentData.dictionaries" metadata="{name: \'Dictionaries\', label: \'Dictionaries in environment\', required: false}" obj-label="id" display-mode="$tabData.mode" handlers="envDictionariesAutocompleteHandlers" new-item-suffix=" (New Dictionary)" open-on-click="true" is-input-visible="false" empty-placeholder="No dictionaries added yet"></div></div><div class="add-or-select-existing-block"><div class="input-component"><div class="input-label"><label>{{ \'terminology.addDictionaryLabel\' | i18n }}</label></div><!--\n		---><div class="input-form"><form><input type="radio" ng-model="$tabData.dictionaryChoice" value="create">{{ \'terminology.addNewDictionaryRadioButton\' | i18n }}<br><input type="radio" ng-model="$tabData.dictionaryChoice" value="existing">{{ \'terminology.selectExistingDictionaryRadioButton\' | i18n }}<br></form></div></div><div class="xl-container xl-container-margin-top xl-container-top-triangle xl-container-top-triangle-33"><div ng-if="$tabData.dictionaryChoice===\'existing\'" class="dictionary-existing"><div xl-widget-item-selector handlers="existingDictionariesHandlers" ng-model="$tabData.environmentData.dictionaries" options="{ description : \'Add existing dictionary to the environment: \', multiple: true }" obj-label="id"></div></div><div ng-if="$tabData.dictionaryChoice===\'create\'" class="dictionary-new"><div>{{ \'terminology.setupNewDictionaryForEnvironment\' | i18n }}</div><div class="input-component"><div xl-dip-string ng-model="$tabData.newDictionary.id" metadata="{name: \'newDictionaryId\', label: \'Dictionary name\', placeholder: \'\'}" display-mode="$tabData.mode"></div><span class="xl-field-description">{{ \'terminology.enterUniqueNameForDictionary\' | i18n }}</span><div id="xl-error" ng-show="postError" xl-widget-alert-message on-dismiss="postError=undefined">{{ postError }}</div></div><div class="map-dictionary"><div xl-dip-map-string-string ng-model="$tabData.newDictionary.entries" entry="$tabData.newDictionary.inputEntry" metadata="{name: \'newDictionaryEntries\', label: \'Entries\', minVisibleRow: 4}" display-mode="$tabData.mode"></div><div xl-dip-map-string-string ng-model="$tabData.newDictionary.encryptedEntries" entry="$tabData.newDictionary.encryptedInputEntry" metadata="{name: \'newDictionaryEncryptedEntries\', label: \'Encrypted Entries\', password: true, minVisibleRow: 4}" display-mode="$tabData.mode"></div></div><div class="xl-button-container"><button type="button" class="xl-button xl-primary" ng-click="addDictionary()" ng-disabled="!isValidDictionary()">{{ \'terminology.addToEnvironmentButton\' | i18n }}</button></div></div></div></div></div>');

  $templateCache.put('environment/tabs/environment/select-existing-container/select-existing-container-modal.html', '<div class="xl-scrollable"><div class="xl-form-wrapper"><div xl-widget-item-selector handlers="existingContainersHandlers" ng-model="selectedContainers" options="{description: \'Select existing container:\', multiple: false}" obj-label="id" empty-placeholder="No container of this type available"></div><div class="xl-button-container"><button ng-click="cancel()" class="xl-button xl-cancel">{{ \'terminology.cancelButton\' | i18n }}</button> <button ng-click="addContainer()" class="xl-button xl-primary" ng-disabled="!hasSelectedContainer()">{{ \'terminology.selectContainerButton\' | i18n }}</button></div></div></div>');

}]);

})();