from xld.openshift.deploymentconfig.deployment_config_helper import DeploymentConfigHelper
from xld.kubernetes.service.exposedservices.service_steps_helper import ExposedServiceStepsHelper

context.addStepWithCheckpoint(steps.jython(
    description="Destroy DeploymentConfig {0}".format(DeploymentConfigHelper.get_deployment_config_name(previousDeployed)),
    script="xld/openshift/deploymentconfig/delete.py",
    order=previousDeployed.destroyOrder
), delta)

context.addStep(steps.jython(
    description="Wait for DeploymentConfig {0} to be deleted".format(DeploymentConfigHelper.get_deployment_config_name(previousDeployed)),
    script="xld/openshift/deploymentconfig/wait_for_delete.py",
    order=previousDeployed.destroyOrder + 1
))

for pod_template in previousDeployed.template:
    services = ExposedServiceStepsHelper.get_exposed_services(pod_template.containers,pod_template.labels,
                                                              DeploymentConfigHelper.get_deployment_config_name(previousDeployed))
    ExposedServiceStepsHelper(context, steps).add_destroy_steps(previousDeployed, services, delta)
