from kubernetes.client.rest import ApiException
from xld.openshift.connector import OpenShiftConnector
from xld.openshift.resource_provider import RouteResourceProvider
from xld.openshift.route.route_helper import RouteHelper

connector = OpenShiftConnector(previousDeployed.container.container)
route_dict = RouteHelper.read_route(previousDeployed)

try:
    print("Deleting route {0}".format(route_dict["metadata"]["name"]))
    with RouteResourceProvider(previousDeployed.container) as route_resource_provider:
        routes = route_resource_provider.delete(namespace=previousDeployed.container.projectName,
                                                                        resource_definition=route_dict)

except ApiException as e:
    print("API error while deleting route: %{0}".format(e))
    raise Exception("Route deletion failed.")
