from xld.openshift.resource_provider import ImageStreamResourceProvider
from xld.openshift.imagestream.image_stream_helper import ImageStreamHelper

result = "SUCCESS"
image_stream_dict = ImageStreamHelper.read_image_stream(deployed)

def __is_created(item):
    return 'status' in dir(item) and 'tags' in dir(item.status) and item.status.tags is not None and len(
        item.status.tags) > 0


def __is_updated(item, image_stream_dict):
    print("WTF: {} -- {}".format(item, image_stream_dict))
    return item.spec.tags[0]["from"].name == image_stream_dict["spec"]["tags"][0]["from"]["name"]


def __get_error_from_tag(tag):
    if 'conditions' in dir(tag) and tag.conditions is not None:
        for condition in tag.conditions:
            if 'message' in dir(condition) and bool(condition.message):
                return condition.message

with ImageStreamResourceProvider(deployed.container) as image_stream_resource_provider:
    image_streams = image_stream_resource_provider.filter_resources_by_definition(namespace=deployed.container.projectName,
                                                                                  resource_definition=image_stream_dict)
print("TESTING: {}".format(image_streams))
for item in image_streams.items:
    if __is_created(item) and __is_updated(item, image_stream_dict):
        if __get_error_from_tag(item.status.tags[0]):
            raise RuntimeError(__get_error_from_tag(item.status.tags[0]))
    else:
        print "Waiting for Image Stream to be created..."
        result = "RETRY"
