from kubernetes.client.rest import ApiException
from xld.openshift.connector import OpenShiftConnector
import requests
with OpenShiftConnector(previousDeployed.container) as connector:
    #new-integ-project-sample
    print("Waiting for project to be deleted: {0}".format(previousDeployed.projectName))
    headers={}
    headers['Authorization']='Bearer '+ previousDeployed.container.openshiftToken
    host = previousDeployed.container.serverUrl
    if host.endswith('/'):
        host = host[:-1]
    url = host+"/apis/project.openshift.io/v1/projects/"+previousDeployed.projectName
    response = requests.get(url = url, headers=headers, verify=False)
    responseLoad = response.json()
    if 'code' in responseLoad:
        if responseLoad['code'] == 404:
            print("Deleted Project : "+previousDeployed.projectName)
    else:
        result = "RETRY"
