from xld.openshift.connector import OpenShiftConnector
from kubernetes.client.rest import ApiException
from xld.openshift.route.route_helper import RouteHelper
from xld.openshift.resource_provider import RouteResourceProvider
from xld.kubernetes.commons.common_utils import CommonUtils

connector = OpenShiftConnector(deployed.container.container)
route_dict = RouteHelper.read_route(deployed)

try:
    print("Updating route {0}".format(route_dict["metadata"]["name"]))
    CommonUtils.print_request_dump(deployed.container.container, route_dict, route_dict["kind"],
                                   route_dict["apiVersion"])
    with RouteResourceProvider(deployed.container) as route_resource_provider:
        routes = route_resource_provider.modify(namespace=deployed.container.projectName,
                                                resource_definition=route_dict)
    CommonUtils.print_response_dump(deployed.container.container, routes)

except ApiException as e:
    print("API error while updating route: {0}".format(e))
    raise RuntimeError("Route modification failed.")
