from xld.openshift.deploymentconfig.deployment_config_helper import DeploymentConfigHelper
from xld.kubernetes.service.exposedservices.service_steps_helper import ExposedServiceStepsHelper

DeploymentConfigHelper.enrich_app_selectors(deployed)
if len(deployed.template) > 1:
    raise RuntimeError("DeploymentConfig can't be created, attribute template cannot have more than one template")

if len(deployed.template) == 0:
    raise RuntimeError("DeploymentConfig can't be created, attribute template is mandatory")

if len(deployed.strategy) > 1:
    raise RuntimeError("DeploymentConfig can't be created, attribute strategy cannot have more than 1 item")

context.addStepWithCheckpoint(steps.jython(
    description="Create DeploymentConfig {0}".format(DeploymentConfigHelper.get_deployment_config_name(deployed)),
    script="xld/openshift/deploymentconfig/create.py",
    order=deployed.createOrder
), delta)

context.addStep(steps.jython(
    description="Wait for DeploymentConfig {0} to be created".format(DeploymentConfigHelper.get_deployment_config_name(deployed)),
    script="xld/openshift/deploymentconfig/create_update_wait.py",
    order=deployed.createOrder + 1
))

for pod_template in deployed.template:
    services = ExposedServiceStepsHelper.get_exposed_services(pod_template.containers,pod_template.labels,
                                                              DeploymentConfigHelper.get_deployment_config_name(deployed))
    ExposedServiceStepsHelper(context, steps).add_create_steps(deployed, services, delta)