# coding: utf-8

"""
    OpenShift API (with Kubernetes)

    OpenShift provides builds, application lifecycle, image content management, and administrative policy on top of Kubernetes. The API allows consistent management of those objects.  All API operations are authenticated via an Authorization bearer token that is provided for service accounts as a generated secret (in JWT form) or via the native OAuth endpoint located at /oauth/authorize. Core infrastructure components may use client certificates that require no authentication.  All API operations return a 'resourceVersion' string that represents the version of the object in the underlying storage. The standard LIST operation performs a snapshot read of the underlying objects, returning a resourceVersion representing a consistent version of the listed objects. The WATCH operation allows all updates to a set of objects after the provided resourceVersion to be observed by a client. By listing and beginning a watch from the returned resourceVersion, clients may observe a consistent view of the state of one or more objects. Note that WATCH always returns the update after the provided resourceVersion. Watch may be extended a limited time in the past - using etcd 2 the watch window is 1000 events (which on a large cluster may only be a few tens of seconds) so clients must explicitly handle the \"watch to old error\" by re-listing.  Objects are divided into two rough categories - those that have a lifecycle and must reflect the state of the cluster, and those that have no state. Objects with lifecycle typically have three main sections:  * 'metadata' common to all objects * a 'spec' that represents the desired state * a 'status' that represents how much of the desired state is reflected on   the cluster at the current time  Objects that have no state have 'metadata' but may lack a 'spec' or 'status' section.  Objects are divided into those that are namespace scoped (only exist inside of a namespace) and those that are cluster scoped (exist outside of a namespace). A namespace scoped resource will be deleted when the namespace is deleted and cannot be created if the namespace has not yet been created or is in the process of deletion. Cluster scoped resources are typically only accessible to admins - resources like nodes, persistent volumes, and cluster policy.  All objects have a schema that is a combination of the 'kind' and 'apiVersion' fields. This schema is additive only for any given version - no backwards incompatible changes are allowed without incrementing the apiVersion. The server will return and accept a number of standard responses that share a common schema - for instance, the common error type is 'unversioned.Status' (described below) and will be returned on any error from the API server.  The API is available in multiple serialization formats - the default is JSON (Accept: application/json and Content-Type: application/json) but clients may also use YAML (application/yaml) or the native Protobuf schema (application/vnd.kubernetes.protobuf). Note that the format of the WATCH API call is slightly different - for JSON it returns newline delimited objects while for Protobuf it returns length-delimited frames (4 bytes in network-order) that contain a 'versioned.Watch' Protobuf object.  See the OpenShift documentation at https://docs.openshift.org for more information. 

    OpenAPI spec version: v1.5.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from pprint import pformat
from six import iteritems
import re


class V1TLSConfig(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self, ca_certificate=None, certificate=None, destination_ca_certificate=None, insecure_edge_termination_policy=None, key=None, termination=None):
        """
        V1TLSConfig - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'ca_certificate': 'str',
            'certificate': 'str',
            'destination_ca_certificate': 'str',
            'insecure_edge_termination_policy': 'str',
            'key': 'str',
            'termination': 'str'
        }

        self.attribute_map = {
            'ca_certificate': 'caCertificate',
            'certificate': 'certificate',
            'destination_ca_certificate': 'destinationCACertificate',
            'insecure_edge_termination_policy': 'insecureEdgeTerminationPolicy',
            'key': 'key',
            'termination': 'termination'
        }

        self._ca_certificate = ca_certificate
        self._certificate = certificate
        self._destination_ca_certificate = destination_ca_certificate
        self._insecure_edge_termination_policy = insecure_edge_termination_policy
        self._key = key
        self._termination = termination

    @property
    def ca_certificate(self):
        """
        Gets the ca_certificate of this V1TLSConfig.
        caCertificate provides the cert authority certificate contents

        :return: The ca_certificate of this V1TLSConfig.
        :rtype: str
        """
        return self._ca_certificate

    @ca_certificate.setter
    def ca_certificate(self, ca_certificate):
        """
        Sets the ca_certificate of this V1TLSConfig.
        caCertificate provides the cert authority certificate contents

        :param ca_certificate: The ca_certificate of this V1TLSConfig.
        :type: str
        """

        self._ca_certificate = ca_certificate

    @property
    def certificate(self):
        """
        Gets the certificate of this V1TLSConfig.
        certificate provides certificate contents

        :return: The certificate of this V1TLSConfig.
        :rtype: str
        """
        return self._certificate

    @certificate.setter
    def certificate(self, certificate):
        """
        Sets the certificate of this V1TLSConfig.
        certificate provides certificate contents

        :param certificate: The certificate of this V1TLSConfig.
        :type: str
        """

        self._certificate = certificate

    @property
    def destination_ca_certificate(self):
        """
        Gets the destination_ca_certificate of this V1TLSConfig.
        destinationCACertificate provides the contents of the ca certificate of the final destination.  When using reencrypt termination this file should be provided in order to have routers use it for health checks on the secure connection

        :return: The destination_ca_certificate of this V1TLSConfig.
        :rtype: str
        """
        return self._destination_ca_certificate

    @destination_ca_certificate.setter
    def destination_ca_certificate(self, destination_ca_certificate):
        """
        Sets the destination_ca_certificate of this V1TLSConfig.
        destinationCACertificate provides the contents of the ca certificate of the final destination.  When using reencrypt termination this file should be provided in order to have routers use it for health checks on the secure connection

        :param destination_ca_certificate: The destination_ca_certificate of this V1TLSConfig.
        :type: str
        """

        self._destination_ca_certificate = destination_ca_certificate

    @property
    def insecure_edge_termination_policy(self):
        """
        Gets the insecure_edge_termination_policy of this V1TLSConfig.
        insecureEdgeTerminationPolicy indicates the desired behavior for insecure connections to a route. While each router may make its own decisions on which ports to expose, this is normally port 80.  * Allow - traffic is sent to the server on the insecure port (default) * Disable - no traffic is allowed on the insecure port. * Redirect - clients are redirected to the secure port.

        :return: The insecure_edge_termination_policy of this V1TLSConfig.
        :rtype: str
        """
        return self._insecure_edge_termination_policy

    @insecure_edge_termination_policy.setter
    def insecure_edge_termination_policy(self, insecure_edge_termination_policy):
        """
        Sets the insecure_edge_termination_policy of this V1TLSConfig.
        insecureEdgeTerminationPolicy indicates the desired behavior for insecure connections to a route. While each router may make its own decisions on which ports to expose, this is normally port 80.  * Allow - traffic is sent to the server on the insecure port (default) * Disable - no traffic is allowed on the insecure port. * Redirect - clients are redirected to the secure port.

        :param insecure_edge_termination_policy: The insecure_edge_termination_policy of this V1TLSConfig.
        :type: str
        """

        self._insecure_edge_termination_policy = insecure_edge_termination_policy

    @property
    def key(self):
        """
        Gets the key of this V1TLSConfig.
        key provides key file contents

        :return: The key of this V1TLSConfig.
        :rtype: str
        """
        return self._key

    @key.setter
    def key(self, key):
        """
        Sets the key of this V1TLSConfig.
        key provides key file contents

        :param key: The key of this V1TLSConfig.
        :type: str
        """

        self._key = key

    @property
    def termination(self):
        """
        Gets the termination of this V1TLSConfig.
        termination indicates termination type.

        :return: The termination of this V1TLSConfig.
        :rtype: str
        """
        return self._termination

    @termination.setter
    def termination(self, termination):
        """
        Sets the termination of this V1TLSConfig.
        termination indicates termination type.

        :param termination: The termination of this V1TLSConfig.
        :type: str
        """
        if termination is None:
            raise ValueError("Invalid value for `termination`, must not be `None`")

        self._termination = termination

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, V1TLSConfig):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
