from xld.openshift.connector import OpenShiftConnector
from org.apache.commons.io import IOUtils
from kubernetes.client.rest import ApiException

result = "SUCCESS"

connector = OpenShiftConnector(deployed.container.container)  # openshift top level entry
os_client = connector.client()

input_stream = deployed.file.getInputStream()

try:
    resourceIS = IOUtils.toString(input_stream, "UTF-8")
finally:
    IOUtils.closeQuietly(input_stream)

resourceDefinition = connector.parse_resource_definition(resourceIS)

try:
    if resourceDefinition["kind"] == "List":
        for resource in resourceDefinition["items"]:
            multi_connector = OpenShiftConnector(deployed.container.container) # openshift top level entry
            resources = multi_connector.filter_resources_by_object(namespace=deployed.container.projectName, resource_object=resource)
            if resources.kind == "PodList":
                starting_pods = [pod for pod in resources.items if pod.status.phase != "Running"]
                if len(starting_pods) > 0:
                    result="RETRY"
            elif resources.kind == "RouteList":
                for item in resources.items:
                    for ingress in item.status.ingress:
                        for condition in ingress.conditions:
                            if condition.type == "Admitted" and condition.status == "Unknown":
                                print("Waiting for Route to be activated ...")
                                result="RETRY"
    else:
        resources = connector.filter_resources_by_object(namespace=deployed.container.projectName, resource_object=resourceDefinition)
        if resources.kind == "PodList":
            starting_pods = [pod for pod in resources.items if pod.status.phase != "Running"]
            if len(starting_pods) > 0:
                result="RETRY"
        elif resources.kind == "RouteList":
                for item in resources.items:
                    for ingress in item.status.ingress:
                        for condition in ingress.conditions:
                            if condition.type == "Admitted" and condition.status == "Unknown":
                                print("Waiting for Route to be activated ...")
                                result="RETRY"

except ApiException as e:
    logger.error("%s" % e)
    print("API error while waiting for resource: %s" % e)
    raise Exception("Resource wait failed.")