from xld.openshift.connector import OpenShiftConnector
from org.apache.commons.io import IOUtils
from kubernetes.client.rest import ApiException

connector = OpenShiftConnector(previousDeployed.container.container)  # openshift top level entry

input_stream = previousDeployed.file.getInputStream()

try:
    resourceIS = IOUtils.toString(input_stream, "UTF-8")
finally:
    IOUtils.closeQuietly(input_stream)

resourceDefinition = connector.parse_resource_definition(resourceIS)

try:
    if resourceDefinition["kind"] == "List":
        for resource in resourceDefinition["items"]:
            print("Deleting resource %s, kind %s" % (resource["metadata"]["name"], resource["kind"]))
            multi_connector = OpenShiftConnector(previousDeployed.container.container) # openshift top level entry
            multi_connector.delete_resource_from_object(namespace=previousDeployed.container.projectName , resource_object=resource)
    else:
        print("Deleting resource %s, kind %s" % (resourceDefinition["metadata"]["name"], resourceDefinition["kind"]))
        connector.delete_resource_from_object(namespace=previousDeployed.container.projectName , resource_object=resourceDefinition)

except ApiException as e:
    logger.error("%s" % e)
    print("API error while deleting resource: %s" % e)
    raise Exception("Resource deletion failed.")