from kubernetes.client.apis import core_v1_api
from openshift import client
from xld.openshift.factories.client_factory import OpenShiftClientFactory


class OpenShiftConnector(object):
    def __init__(self, server):
        self.apiclient = OpenShiftClientFactory(server).create()
        self.oapi = client.OapiApi(self.apiclient)
        self.k8sapi = core_v1_api.CoreV1Api(self.apiclient)

    def client(self):
        return self.apiclient

    def oapi_client(self):
        return self.oapi
