from xld.openshift.connector import OpenShiftConnector
from xld.openshift.resource_provider import DeploymentConfigResourceProvider
from xld.openshift.deploymentconfig.deployment_config_helper import DeploymentConfigHelper

result = "SUCCESS"
connector = OpenShiftConnector(deployed.container.container)
deployment_config_dict = DeploymentConfigHelper.read_deployment_config(deployed)

deployment_config_resource_provider = DeploymentConfigResourceProvider(deployed.container)
deployment_config = deployment_config_resource_provider.filter_resources_by_definition(namespace=deployed.container.projectName,
                                                                                       resource_definition=deployment_config_dict)


for item in deployment_config.items:
    for trigger in item.spec.triggers:
        if trigger.image_change_params.automatic:
            if item.status.ready_replicas is None or item.status.ready_replicas < item.spec.replicas:
                print("Waiting for DeploymentConfig's pod {0} to be in running state".format(item.metadata.name))
                result = "RETRY"