from xld.openshift.connector import OpenShiftConnector
from xld.openshift.resource_provider import DeploymentConfigResourceProvider
from xld.openshift.deploymentconfig.deployment_config_helper import DeploymentConfigHelper

result = "SUCCESS"
connector = OpenShiftConnector(deployed.container.container)
deployment_config_dict = DeploymentConfigHelper.read_deployment_config(deployed)

with DeploymentConfigResourceProvider(deployed.container) as deployment_config_resource_provider:
    deployment_config = deployment_config_resource_provider.filter_resources_by_definition(
        namespace=deployed.container.projectName,
        resource_definition=deployment_config_dict)


# hack method to fail process if pods are not at a ready status. result 'FAIL' does not work
def processFail():
    print ("None of the pods were at a ready status after reaching the max number of retries. \n")
    raise Exception(
        "Max number of retries reached. Please verify if readiness probe check is correct or increase the number 'Readiness Probe Retry' in ci properties... \n")
    # fails the deployment here
    exit(1)


def processItem(item):
    if item.status.ready_replicas is None or item.status.ready_replicas < item.spec.replicas:
        if deployed.readinessProbeRetry > 0:
            print(
                "Waiting for DeploymentConfig's {0} to have pods in running state, retries left: {1} (Approx {2} seconds)".format(
                    item.metadata.name, deployed.readinessProbeRetry, deployed.readinessProbeRetry * 5))
            deployed.readinessProbeRetry -= 1
            return "RETRY"

        else:
            processFail()
    return "SUCCESS"


for item in deployment_config.items:
    if (deployed.validatePodsCreation):
        result = processItem(item)
