from kubernetes.client.rest import ApiException
from xld.openshift.resource_provider import ImageStreamResourceProvider
from xld.openshift.imagestream.image_stream_helper import ImageStreamHelper

image_stream_dict = ImageStreamHelper.read_image_stream(previousDeployed)
with ImageStreamResourceProvider(previousDeployed.container) as image_stream_resource_provider:
    try:
        print("Deleting Image Stream {0}".format(image_stream_dict["metadata"]["name"]))
        image_stream_resource_provider.delete(namespace=previousDeployed.container.projectName,
                                              resource_definition=image_stream_dict)

    except ApiException as e:
        print("API error while deleting route: %{0}".format(e))
        raise Exception("Route deletion failed.")
