from xld.openshift.imagestream.image_stream_helper import ImageStreamHelper

previous_image_stream_name = previousDeployed.imageStreamName if previousDeployed.imageStreamName else previousDeployed.name
image_stream_name = ImageStreamHelper.get_image_stream_name(deployed)
if image_stream_name != previous_image_stream_name:
    raise RuntimeError("Image Stream name can't be modified.")

context.addStepWithCheckpoint(steps.jython(
    description="Modify Image Stream {0}".format(ImageStreamHelper.get_image_stream_name(deployed)),
    script="xld/openshift/imagestream/update.py",
    order=65
), delta)

context.addStep(steps.jython(
    description="Wait for Image Stream {0} to be modified".format(ImageStreamHelper.get_image_stream_name(deployed)),
    script="xld/openshift/imagestream/create_update_wait.py",
    order=66
))
