/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.xebialabs.deployit.plugin.BasePatchDictionary;
import com.xebialabs.deployit.plugin.JsonPatchDictionary$ApplicationConfig$;
import com.xebialabs.deployit.plugin.SampleFileType;
import com.xebialabs.deployit.plugin.SourceType;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.DeployableArtifact;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.deployit.plugin.api.udm.TypeIcon;
import com.xebialabs.deployit.plugin.api.udm.base.BaseConfigurationItem;
import com.xebialabs.json_patch.JsonActivators;
import com.xebialabs.json_patch.JsonPatch;
import com.xebialabs.json_patch.JsonSupport;
import com.xebialabs.json_patch.YamlPatch;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.io.IOUtils;
import org.slf4j.Marker;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Product;
import scala.collection.Iterator;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ScalaRunTime$;

@Metadata(root=Metadata.ConfigurationItemRoot.ENVIRONMENTS, description="A JSON Patch Dictionary contains Environment-specific entries for non-intrusive dictionary value resolution")
@TypeIcon(value="icons/types/udm.Dictionary.svg")
@ScalaSignature(bytes="\u0006\u0001\rEd\u0001\u0002!B\u0001)CQa\u001a\u0001\u0005\u0002!DqA\u001b\u0001C\u0002\u001351\u000e\u0003\u0004p\u0001\u0001\u0006i\u0001\u001c\u0005\ba\u0002\u0001\r\u0011\"\u0001r\u0011!y\b\u00011A\u0005\u0002\u0005\u0005\u0001bBA\b\u0001\u0001\u0006KA\u001d\u0005\t\u0003k\u0001\u0001\u0019!C\u0001c\"I\u0011q\u0007\u0001A\u0002\u0013\u0005\u0011\u0011\b\u0005\b\u0003{\u0001\u0001\u0015)\u0003s\u0011%\tY\u0005\u0001a\u0001\n\u0003\ti\u0005C\u0005\u0002^\u0001\u0001\r\u0011\"\u0001\u0002`!A\u00111\r\u0001!B\u0013\ty\u0005C\u0005\u0002t\u0001\u0001\r\u0011\"\u0001\u0002N!I\u0011Q\u000f\u0001A\u0002\u0013\u0005\u0011q\u000f\u0005\t\u0003w\u0002\u0001\u0015)\u0003\u0002P!I\u00111\u0011\u0001A\u0002\u0013\u0005\u0011Q\u0011\u0005\n\u0003\u001b\u0003\u0001\u0019!C\u0001\u0003\u001fC\u0001\"a%\u0001A\u0003&\u0011q\u0011\u0005\n\u00037\u0003\u0001\u0019!C\u0001\u0003;C\u0011\"a+\u0001\u0001\u0004%\t!!,\t\u0011\u0005E\u0006\u0001)Q\u0005\u0003?C\u0011\"!/\u0001\u0001\u0004%\t!a/\t\u0013\u0005\r\u0007\u00011A\u0005\u0002\u0005\u0015\u0007\u0002CAe\u0001\u0001\u0006K!!0\t\u0013\u0005E\u0007\u00011A\u0005\u0002\u00055\u0003\"CAj\u0001\u0001\u0007I\u0011AAk\u0011!\tI\u000e\u0001Q!\n\u0005=\u0003\u0002CAq\u0001\u0001\u0007I\u0011A9\t\u0013\u0005\r\b\u00011A\u0005\u0002\u0005\u0015\bbBAu\u0001\u0001\u0006KA\u001d\u0005\t\u0003c\u0004\u0001\u0019!C\u0001c\"I\u00111\u001f\u0001A\u0002\u0013\u0005\u0011Q\u001f\u0005\b\u0003s\u0004\u0001\u0015)\u0003s\r\u0019\u0011\t\u0001\u0001!\u0003\u0004!I!q\u0003\u0012\u0003\u0016\u0004%\t!\u001d\u0005\n\u00053\u0011#\u0011#Q\u0001\nID!Ba\u0007#\u0005+\u0007I\u0011\u0001B\u000f\u0011)\u0011)C\tB\tB\u0003%!q\u0004\u0005\u000b\u0005O\u0011#Q3A\u0005\u0002\t%\u0002B\u0003B\u001cE\tE\t\u0015!\u0003\u0003,!1qM\tC\u0001\u0005sA\u0011B!\u0012#\u0003\u0003%\tAa\u0012\t\u0013\t=#%%A\u0005\u0002\tE\u0003\"\u0003B4EE\u0005I\u0011\u0001B5\u0011%\u0011iGII\u0001\n\u0003\u0011y\u0007C\u0005\u0003t\t\n\t\u0011\"\u0011\u0002N!I!Q\u000f\u0012\u0002\u0002\u0013\u0005!q\u000f\u0005\n\u0005\u007f\u0012\u0013\u0011!C\u0001\u0005\u0003C\u0011Ba##\u0003\u0003%\tE!$\t\u0013\tm%%!A\u0005\u0002\tu\u0005\"\u0003BTE\u0005\u0005I\u0011\tBU\u0011%\u0011YKIA\u0001\n\u0003\u0012i\u000bC\u0005\u00030\n\n\t\u0011\"\u0011\u00032\u001eI!Q\u0017\u0001\u0002\u0002#\u0005!q\u0017\u0004\n\u0005\u0003\u0001\u0011\u0011!E\u0001\u0005sCaaZ\u001c\u0005\u0002\t\u001d\u0007\"\u0003BVo\u0005\u0005IQ\tBW\u0011%\u0011ImNA\u0001\n\u0003\u0013Y\rC\u0005\u0003T^\n\t\u0011\"!\u0003V\"9!q\u001d\u0001\u0005\n\t%\bb\u0002Be\u0001\u0011\u000531\u0007\u0005\b\u0007w\u0001A\u0011AB\u001f\u0011\u001d\u0019\t\u0005\u0001C\u0001\u0007\u0007\u00121CS:p]B\u000bGo\u00195ES\u000e$\u0018n\u001c8befT!AQ\"\u0002\rAdWoZ5o\u0015\t!U)\u0001\u0005eKBdw._5u\u0015\t1u)A\u0005yK\nL\u0017\r\\1cg*\t\u0001*A\u0002d_6\u001c\u0001aE\u0003\u0001\u0017VK\u0016\r\u0005\u0002M'6\tQJ\u0003\u0002O\u001f\u0006!!-Y:f\u0015\t\u0001\u0016+A\u0002vI6T!AU!\u0002\u0007\u0005\u0004\u0018.\u0003\u0002U\u001b\n)\")Y:f\u0007>tg-[4ve\u0006$\u0018n\u001c8Ji\u0016l\u0007C\u0001,X\u001b\u0005\t\u0015B\u0001-B\u0005M\u0011\u0015m]3QCR\u001c\u0007\u000eR5di&|g.\u0019:z!\tQv,D\u0001\\\u0015\taV,A\u0003tY\u001a$$NC\u0001_\u0003!9'/\u001b>{Y\u0016$\u0017B\u00011\\\u0005\u001daunZ4j]\u001e\u0004\"AY3\u000e\u0003\rT!\u0001Z#\u0002\u0015)\u001cxN\\0qCR\u001c\u0007.\u0003\u0002gG\nY!j]8o'V\u0004\bo\u001c:u\u0003\u0019a\u0014N\\5u}Q\t\u0011\u000e\u0005\u0002W\u0001\u0005!2/\u001a7fGR\u001c\u0016-\u001c9mK\u000e\u000bG/Z4pef,\u0012\u0001\\\b\u0002[\u0006\na.A\u0007TK2,7\r\u001e\u0011tC6\u0004H.Z\u0001\u0016g\u0016dWm\u0019;TC6\u0004H.Z\"bi\u0016<wN]=!\u0003\u001d\u0001\u0018\r^2iKN,\u0012A\u001d\t\u0003grt!\u0001\u001e>\u0011\u0005UDX\"\u0001<\u000b\u0005]L\u0015A\u0002\u001fs_>$hHC\u0001z\u0003\u0015\u00198-\u00197b\u0013\tY\b0\u0001\u0004Qe\u0016$WMZ\u0005\u0003{z\u0014aa\u0015;sS:<'BA>y\u0003-\u0001\u0018\r^2iKN|F%Z9\u0015\t\u0005\r\u00111\u0002\t\u0005\u0003\u000b\t9!D\u0001y\u0013\r\tI\u0001\u001f\u0002\u0005+:LG\u000f\u0003\u0005\u0002\u000e\u0015\t\t\u00111\u0001s\u0003\rAH%M\u0001\ta\u0006$8\r[3tA!za!a\u0005\u0002\u001c\u0005u\u0011\u0011EA\u0012\u0003c\t\u0019\u0004\u0005\u0003\u0002\u0016\u0005]Q\"A(\n\u0007\u0005eqJ\u0001\u0005Qe>\u0004XM\u001d;z\u0003-!Wm]2sSB$\u0018n\u001c8\"\u0005\u0005}\u0011\u0001\u000b+iK\u0002\u0002\u0018\r^2iA\u0015tGO]5fg\u0002\"\b.\u0019;!Q\u00064X\r\t2fK:\u00043M]3bi\u0016$\u0017\u0001B:ju\u0016$#!!\n\n\t\u0005\u001d\u0012\u0011F\u0001\u0006\u0019\u0006\u0013v)\u0012\u0006\u0005\u0003W\ti#\u0001\u0003TSj,'bAA\u0018\u001f\u0006A\u0001K]8qKJ$\u00180\u0001\u0005sKF,\u0018N]3e3\u0005\t\u0011AC1di&4\u0018\r^8sg\u0006q\u0011m\u0019;jm\u0006$xN]:`I\u0015\fH\u0003BA\u0002\u0003wA\u0001\"!\u0004\t\u0003\u0003\u0005\rA]\u0001\fC\u000e$\u0018N^1u_J\u001c\b\u0005K\n\n\u0003'\tY\"!\u0011\u0002\"\u0005\r\u0012\u0011GA#\u0003\u000f\nI%\t\u0002\u0002D\u0005IC\u000b[3!\u0015N{e\nI1di&4\u0018\r^5p]\u0002*g\u000e\u001e:jKN\u0004\u0013m\u001d\u0011K'>s\u0005%\u0011:sCfL\u0012\u0001A\u0001\tG\u0006$XmZ8ss\u0006\u0012\u0011QG\u0001\u000eUN|gNR5mKJ+w-\u001a=\u0016\u0005\u0005=\u0003\u0003BA)\u00037j!!a\u0015\u000b\t\u0005U\u0013qK\u0001\u0005Y\u0006twM\u0003\u0002\u0002Z\u0005!!.\u0019<b\u0013\ri\u00181K\u0001\u0012UN|gNR5mKJ+w-\u001a=`I\u0015\fH\u0003BA\u0002\u0003CB\u0011\"!\u0004\f\u0003\u0003\u0005\r!a\u0014\u0002\u001d)\u001cxN\u001c$jY\u0016\u0014VmZ3yA!zA\"a\u0005\u0002\u001c\u0005\u001d\u00141NA7\u0003c\n\u0019$\t\u0002\u0002j\u0005A&+Z4vY\u0006\u0014\b%\u001a=qe\u0016\u001c8/[8oAQ|\u0007%\u001b3f]RLg-\u001f\u0011xQ&\u001c\u0007\u000e\t;za\u0016\u001c\be\u001c4!M&dWm\u001d\u0011uQ\u0016\u0004\u0003/\u0019;dQ\u0002*g\u000e\u001e:jKN\u0004s/\u001b7mA\t,\u0007%\u00199qY&,G\r\t;p\u00031!WMZ1vYR4\u0016\r\\;fC\t\ty'\u0001\u0006/Wqs\u0003F[:p]&\na\u0001[5eI\u0016t\u0017!D=b[24\u0015\u000e\\3SK\u001e,\u00070A\tzC6dg)\u001b7f%\u0016<W\r_0%KF$B!a\u0001\u0002z!I\u0011Q\u0002\b\u0002\u0002\u0003\u0007\u0011qJ\u0001\u000fs\u0006lGNR5mKJ+w-\u001a=!Q=y\u00111CA\u000e\u0003O\nY'a \u0002r\u0005M\u0012EAAA\u00039q3\u0006\u0018\u0018)s\u0006lG\u000e`=nY&\n!b]8ve\u000e,G+\u001f9f+\t\t9\tE\u0002W\u0003\u0013K1!a#B\u0005)\u0019v.\u001e:dKRK\b/Z\u0001\u000fg>,(oY3UsB,w\fJ3r)\u0011\t\u0019!!%\t\u0013\u00055\u0011#!AA\u0002\u0005\u001d\u0015aC:pkJ\u001cW\rV=qK\u0002BcBEA\n\u0003\u000fj\u00171DAL\u0003c\t)%\t\u0002\u0002\u001a\u0006YD\u000b[3!g>,(oY3!_\u001a\u0004C\u000f[3!g\u0006l\u0007\u000f\\3!i\"\fG\u000fI<jY2\u0004#-\u001a\u0011qe>4\u0018\u000eZ3eA\u0019|'\u000f\t9bi\u000eD\u0017N\\4\u0002\u0011A\f7m[1hKN,\"!a(\u0011\u000b\u0005\u0005\u0016q\u0015:\u000e\u0005\u0005\r&\u0002BAS\u0003/\nA!\u001e;jY&!\u0011\u0011VAR\u0005\r\u0019V\r^\u0001\ra\u0006\u001c7.Y4fg~#S-\u001d\u000b\u0005\u0003\u0007\ty\u000bC\u0005\u0002\u000eQ\t\t\u00111\u0001\u0002 \u0006I\u0001/Y2lC\u001e,7\u000f\t\u0015\u000f+\u0005M\u0011qI7\u0002\u001c\u0005U\u0016\u0011GA#C\t\t9,A!MSN$\be\u001c4!a\u0006\u001c7.Y4fg\u0002\"x\u000eI:dC:\u0004cm\u001c:!M&dWm\u001d\u0011d_:$\u0018-\u001b8j]\u001e\u00043/Y7qY\u0016\u001c\bEZ8sAA\fGo\u00195fg\u0006q1-^:u_64\u0015\u000e\\3UsB,WCAA_!\r1\u0016qX\u0005\u0004\u0003\u0003\f%AD*b[BdWMR5mKRK\b/Z\u0001\u0013GV\u001cHo\\7GS2,G+\u001f9f?\u0012*\u0017\u000f\u0006\u0003\u0002\u0004\u0005\u001d\u0007\"CA\u0007/\u0005\u0005\t\u0019AA_\u0003=\u0019Wo\u001d;p[\u001aKG.\u001a+za\u0016\u0004\u0003F\u0004\r\u0002\u0014\u0005\u001dS.a\u0007\u0002N\u0006E\u0012QI\u0011\u0003\u0003\u001f\fa\u0003\u00165fAQL\b/\u001a\u0011pM\u0002\"\b.\u001a\u0011tC6\u0004H.Z\u0001\rGV\u001cHo\\7TC6\u0004H.Z\u0001\u0011GV\u001cHo\\7TC6\u0004H.Z0%KF$B!a\u0001\u0002X\"I\u0011Q\u0002\u000e\u0002\u0002\u0003\u0007\u0011qJ\u0001\u000eGV\u001cHo\\7TC6\u0004H.\u001a\u0011)\u001dm\t\u0019\"a\u0012n\u00037\ti.!\r\u0002F\u0005\u0012\u0011q\\\u0001\u0017)\",\u0007\u0005^3yi\u0002zg\r\t;iK\u0002\u001a\u0018-\u001c9mK\u0006\u00012/\u001a7fGR,G-\u0011:uS\u001a\f7\r^\u0001\u0015g\u0016dWm\u0019;fI\u0006\u0013H/\u001b4bGR|F%Z9\u0015\t\u0005\r\u0011q\u001d\u0005\t\u0003\u001bi\u0012\u0011!a\u0001e\u0006\t2/\u001a7fGR,G-\u0011:uS\u001a\f7\r\u001e\u0011)\u0017y\t\u0019\"a\u0007\u0002n\u0006E\u0012QI\u0011\u0003\u0003_\f\u0001hU3mK\u000e$X\r\u001a\u0011beRLg-Y2uA\u0019|'\u000fI2sK\u0006$\u0018N\\4!a\u0006$8\r[3tA\u0005tGmL8sA\u0005\u001cG/\u001b<bi>\u00148/\u0001\ttK2,7\r^3e\t>\u001cW/\\3oi\u0006!2/\u001a7fGR,G\rR8dk6,g\u000e^0%KF$B!a\u0001\u0002x\"A\u0011Q\u0002\u0011\u0002\u0002\u0003\u0007!/A\ttK2,7\r^3e\t>\u001cW/\\3oi\u0002B3\"IA\n\u00037\ti0!\r\u0002F\u0005\u0012\u0011q`\u0001>'\u0016dWm\u0019;fI\u0002J\u0016)\u0014'!I>\u001cW/\\3oi\u00022wN\u001d\u0011de\u0016\fG/\u001b8hAA\fGo\u00195fg\u0002\ng\u000eZ\u0018pe\u0002\n7\r^5wCR|'o\u001d\u0002\u0012\u0003B\u0004H.[2bi&|gnQ8oM&<7c\u0002\u0012\u0003\u0006\t-!\u0011\u0003\t\u0005\u0003\u000b\u00119!C\u0002\u0003\na\u0014a!\u00118z%\u00164\u0007\u0003BA\u0003\u0005\u001bI1Aa\u0004y\u0005\u001d\u0001&o\u001c3vGR\u0004B!!\u0002\u0003\u0014%\u0019!Q\u0003=\u0003\u0019M+'/[1mSj\f'\r\\3\u0002\u0011\u0019LG.\u001a(b[\u0016\f\u0011BZ5mK:\u000bW.\u001a\u0011\u0002\u0005\rLWC\u0001B\u0010!\u0011\t)B!\t\n\u0007\t\rrJA\tD_:4\u0017nZ;sCRLwN\\%uK6\f1aY5!\u00035y'/[4j]\u0006d')\u001f;fgV\u0011!1\u0006\t\u0007\u0003\u000b\u0011iC!\r\n\u0007\t=\u0002PA\u0003BeJ\f\u0017\u0010\u0005\u0003\u0002\u0006\tM\u0012b\u0001B\u001bq\n!!)\u001f;f\u00039y'/[4j]\u0006d')\u001f;fg\u0002\"\u0002Ba\u000f\u0003@\t\u0005#1\t\t\u0004\u0005{\u0011S\"\u0001\u0001\t\r\t]\u0011\u00061\u0001s\u0011\u001d\u0011Y\"\u000ba\u0001\u0005?AqAa\n*\u0001\u0004\u0011Y#\u0001\u0003d_BLH\u0003\u0003B\u001e\u0005\u0013\u0012YE!\u0014\t\u0011\t]!\u0006%AA\u0002ID\u0011Ba\u0007+!\u0003\u0005\rAa\b\t\u0013\t\u001d\"\u0006%AA\u0002\t-\u0012AD2paf$C-\u001a4bk2$H%M\u000b\u0003\u0005'R3A\u001dB+W\t\u00119\u0006\u0005\u0003\u0003Z\t\rTB\u0001B.\u0015\u0011\u0011iFa\u0018\u0002\u0013Ut7\r[3dW\u0016$'b\u0001B1q\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\t\u0015$1\f\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017AD2paf$C-\u001a4bk2$HEM\u000b\u0003\u0005WRCAa\b\u0003V\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\u001aTC\u0001B9U\u0011\u0011YC!\u0016\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y\u00031\u0001(o\u001c3vGR\f%/\u001b;z+\t\u0011I\b\u0005\u0003\u0002\u0006\tm\u0014b\u0001B?q\n\u0019\u0011J\u001c;\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR!!1\u0011BE!\u0011\t)A!\"\n\u0007\t\u001d\u0005PA\u0002B]fD\u0011\"!\u00041\u0003\u0003\u0005\rA!\u001f\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"Aa$\u0011\r\tE%q\u0013BB\u001b\t\u0011\u0019JC\u0002\u0003\u0016b\f!bY8mY\u0016\u001cG/[8o\u0013\u0011\u0011IJa%\u0003\u0011%#XM]1u_J\f\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u0005\u0005?\u0013)\u000b\u0005\u0003\u0002\u0006\t\u0005\u0016b\u0001BRq\n9!i\\8mK\u0006t\u0007\"CA\u0007e\u0005\u0005\t\u0019\u0001BB\u0003!A\u0017m\u001d5D_\u0012,GC\u0001B=\u0003!!xn\u0015;sS:<GCAA(\u0003\u0019)\u0017/^1mgR!!q\u0014BZ\u0011%\ti!NA\u0001\u0002\u0004\u0011\u0019)A\tBaBd\u0017nY1uS>t7i\u001c8gS\u001e\u00042A!\u00108'\u00159$1\u0018B\t!-\u0011iLa1s\u0005?\u0011YCa\u000f\u000e\u0005\t}&b\u0001Baq\u00069!/\u001e8uS6,\u0017\u0002\u0002Bc\u0005\u007f\u0013\u0011#\u00112tiJ\f7\r\u001e$v]\u000e$\u0018n\u001c84)\t\u00119,A\u0003baBd\u0017\u0010\u0006\u0005\u0003<\t5'q\u001aBi\u0011\u0019\u00119B\u000fa\u0001e\"9!1\u0004\u001eA\u0002\t}\u0001b\u0002B\u0014u\u0001\u0007!1F\u0001\bk:\f\u0007\u000f\u001d7z)\u0011\u00119Na9\u0011\r\u0005\u0015!\u0011\u001cBo\u0013\r\u0011Y\u000e\u001f\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0013\u0005\u0015!q\u001c:\u0003 \t-\u0012b\u0001Bqq\n1A+\u001e9mKNB\u0011B!:<\u0003\u0003\u0005\rAa\u000f\u0002\u0007a$\u0003'\u0001\bbaBd\u00170\u00134NCR\u001c\u0007.Z:\u0015\u0015\t-81AB\u0004\u0007\u0017\u0019\u0019C\u0005\u0004\u0003n\n\u0015!\u0011\u001f\u0004\u0007\u0005_d\u0004Aa;\u0003\u0019q\u0012XMZ5oK6,g\u000e\u001e \u0011\u0011\u0005\u0015!1\u001fB\u001e\u0005oL1A!>y\u0005=\u0001\u0016M\u001d;jC24UO\\2uS>t\u0007\u0003\u0002B}\u0005\u007fl!Aa?\u000b\t\tu\u0018qK\u0001\u0003S>LAa!\u0001\u0003|\nY\u0011J\u001c9viN#(/Z1n\u0011\u0019\u0019)\u0001\u0010a\u0001e\u0006!1.\u001b8e\u0011\u0019\u0019I\u0001\u0010a\u0001e\u0006ia-\u001b7f\u001d\u0006lWMU3hKbDqa!\u0004=\u0001\u0004\u0019y!\u0001\u0007pE*,7\r^'baB,'\u000f\u0005\u0003\u0004\u0012\r}QBAB\n\u0015\u0011\u0019)ba\u0006\u0002\u0011\u0011\fG/\u00192j]\u0012TAa!\u0007\u0004\u001c\u00059!.Y2lg>t'bAB\u000f\u000f\u0006Ia-Y:uKJDX\u000e\\\u0005\u0005\u0007C\u0019\u0019B\u0001\u0007PE*,7\r^'baB,'\u000fC\u0004\u0004&q\u0002\raa\n\u0002\u0015\u0005\u0004\b\u000f\\=QCR\u001c\u0007\u000eE\u0005\u0002\u0006\r%\"o!\f\u0003x&\u001911\u0006=\u0003\u0013\u0019+hn\u0019;j_:\u0014\u0004\u0003BB\t\u0007_IAa!\r\u0004\u0014\tA!j]8o\u001d>$W\r\u0006\u0004\u0003x\u000eU2\u0011\b\u0005\b\u0007oi\u0004\u0019\u0001B|\u0003-Ig\u000e];u'R\u0014X-Y7\t\u000f\tmQ\b1\u0001\u0003 \u0005Q1/\u001a;QCR\u001c\u0007.Z:\u0015\t\u0005\r1q\b\u0005\u0006az\u0002\rA]\u0001\u000eg\u0016$\u0018i\u0019;jm\u0006$xN]:\u0015\t\u0005\r1Q\t\u0005\u0007\u0003ky\u0004\u0019\u0001:)\u000f\u0001\u0019Iea\u0014\u0004RA!\u0011QCB&\u0013\r\u0019ie\u0014\u0002\t)f\u0004X-S2p]\u0006)a/\u00197vK\u0006\u001211K\u0001\u001fS\u000e|gn]\u0018usB,7oL;e[:\"\u0015n\u0019;j_:\f'/\u001f\u0018tm\u001eD3\u0002AB,\u0007;\u001ay&a\u0007\u0004nA!\u0011QCB-\u0013\r\u0019Yf\u0014\u0002\t\u001b\u0016$\u0018\rZ1uC\u0006!!o\\8uI\t\u0019\t'\u0003\u0003\u0004d\r\u0015\u0014\u0001D#O-&\u0013vJT'F\u001dR\u001b&\u0002BB4\u0007S\nQcQ8oM&<WO]1uS>t\u0017\n^3n%>|GOC\u0002\u0004l=\u000b\u0001\"T3uC\u0012\fG/Y\u0011\u0003\u0007_\n1.\u0011\u0011K'>s\u0005\u0005U1uG\"\u0004C)[2uS>t\u0017M]=!G>tG/Y5og\u0002*eN^5s_:lWM\u001c;.gB,7-\u001b4jG\u0002*g\u000e\u001e:jKN\u0004cm\u001c:!]>tW&\u001b8ueV\u001c\u0018N^3!I&\u001cG/[8oCJL\bE^1mk\u0016\u0004#/Z:pYV$\u0018n\u001c8")
public class JsonPatchDictionary
extends BaseConfigurationItem
implements BasePatchDictionary,
Logging,
JsonSupport {
    private volatile JsonPatchDictionary$ApplicationConfig$ ApplicationConfig$module;
    @Property(description="The patch entries that have been created", size=Property.Size.LARGE, required=true)
    private String patches;
    @Property(description="The JSON activation entries as JSON Array", size=Property.Size.LARGE, required=false, category="activators")
    private String activators;
    @Property(description="Regular expression to identify which types of files the patch entries will be applied to", defaultValue=".+\\.(json)", hidden=true)
    private String jsonFileRegex;
    @Property(description="Regular expression to identify which types of files the patch entries will be applied to", defaultValue=".+\\.(yaml|yml)", hidden=true)
    private String yamlFileRegex;
    @Property(category="Select sample", description="The source of the sample that will be provided for patching", required=false)
    private SourceType sourceType;
    @Property(category="Select sample", description="List of packages to scan for files containing samples for patches", required=false)
    private Set<String> packages;
    @Property(category="Select sample", description="The type of the sample", required=false)
    private SampleFileType customFileType;
    @Property(category="Select sample", description="The text of the sample", required=false)
    private String customSample;
    @Property(description="Selected artifact for creating patches and/or activators", required=false)
    private String selectedArtifact;
    @Property(description="Selected YAML document for creating patches and/or activators", required=false)
    private String selectedDocument;
    private final JsonFactory jsonFactory;
    private final YAMLFactory yamlFactory;
    private final ObjectMapper jsonMapper;
    private final ObjectMapper yamlMapper;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    public JsonPatchDictionary$ApplicationConfig$ ApplicationConfig() {
        if (this.ApplicationConfig$module == null) {
            this.ApplicationConfig$lzycompute$1();
        }
        return this.ApplicationConfig$module;
    }

    public JsonFactory jsonFactory() {
        return this.jsonFactory;
    }

    public YAMLFactory yamlFactory() {
        return this.yamlFactory;
    }

    public ObjectMapper jsonMapper() {
        return this.jsonMapper;
    }

    public ObjectMapper yamlMapper() {
        return this.yamlMapper;
    }

    public void com$xebialabs$json_patch$JsonSupport$_setter_$jsonFactory_$eq(JsonFactory x$1) {
        this.jsonFactory = x$1;
    }

    public void com$xebialabs$json_patch$JsonSupport$_setter_$yamlFactory_$eq(YAMLFactory x$1) {
        this.yamlFactory = x$1;
    }

    public void com$xebialabs$json_patch$JsonSupport$_setter_$jsonMapper_$eq(ObjectMapper x$1) {
        this.jsonMapper = x$1;
    }

    public void com$xebialabs$json_patch$JsonSupport$_setter_$yamlMapper_$eq(ObjectMapper x$1) {
        this.yamlMapper = x$1;
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        JsonPatchDictionary jsonPatchDictionary = this;
        synchronized (jsonPatchDictionary) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$trans$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    private final String selectSampleCategory() {
        return "Select sample";
    }

    public String patches() {
        return this.patches;
    }

    public void patches_$eq(String x$1) {
        this.patches = x$1;
    }

    public String activators() {
        return this.activators;
    }

    public void activators_$eq(String x$1) {
        this.activators = x$1;
    }

    public String jsonFileRegex() {
        return this.jsonFileRegex;
    }

    public void jsonFileRegex_$eq(String x$1) {
        this.jsonFileRegex = x$1;
    }

    public String yamlFileRegex() {
        return this.yamlFileRegex;
    }

    public void yamlFileRegex_$eq(String x$1) {
        this.yamlFileRegex = x$1;
    }

    public SourceType sourceType() {
        return this.sourceType;
    }

    public void sourceType_$eq(SourceType x$1) {
        this.sourceType = x$1;
    }

    public Set<String> packages() {
        return this.packages;
    }

    public void packages_$eq(Set<String> x$1) {
        this.packages = x$1;
    }

    public SampleFileType customFileType() {
        return this.customFileType;
    }

    public void customFileType_$eq(SampleFileType x$1) {
        this.customFileType = x$1;
    }

    public String customSample() {
        return this.customSample;
    }

    public void customSample_$eq(String x$1) {
        this.customSample = x$1;
    }

    public String selectedArtifact() {
        return this.selectedArtifact;
    }

    public void selectedArtifact_$eq(String x$1) {
        this.selectedArtifact = x$1;
    }

    public String selectedDocument() {
        return this.selectedDocument;
    }

    public void selectedDocument_$eq(String x$1) {
        this.selectedDocument = x$1;
    }

    private PartialFunction<ApplicationConfig, InputStream> applyIfMatches(String kind, String fileNameRegex, ObjectMapper objectMapper, Function2<String, JsonNode, InputStream> applyPatch) {
        return new PartialFunction<ApplicationConfig, InputStream>(this, fileNameRegex, kind, objectMapper, applyPatch){
            private final /* synthetic */ JsonPatchDictionary $outer;
            private final String fileNameRegex$1;
            private final String kind$1;
            private final ObjectMapper objectMapper$1;
            private final Function2 applyPatch$1;

            public <A1 extends ApplicationConfig, B1> PartialFunction<A1, B1> orElse(PartialFunction<A1, B1> that) {
                return PartialFunction.orElse$((PartialFunction)this, that);
            }

            public <C> PartialFunction<ApplicationConfig, C> andThen(Function1<InputStream, C> k) {
                return PartialFunction.andThen$((PartialFunction)this, k);
            }

            public Function1<ApplicationConfig, Option<InputStream>> lift() {
                return PartialFunction.lift$((PartialFunction)this);
            }

            public Object applyOrElse(Object x, Function1 function1) {
                return PartialFunction.applyOrElse$((PartialFunction)this, (Object)x, (Function1)function1);
            }

            public <U> Function1<ApplicationConfig, Object> runWith(Function1<InputStream, U> action) {
                return PartialFunction.runWith$((PartialFunction)this, action);
            }

            public boolean apply$mcZD$sp(double v1) {
                return Function1.apply$mcZD$sp$((Function1)this, (double)v1);
            }

            public double apply$mcDD$sp(double v1) {
                return Function1.apply$mcDD$sp$((Function1)this, (double)v1);
            }

            public float apply$mcFD$sp(double v1) {
                return Function1.apply$mcFD$sp$((Function1)this, (double)v1);
            }

            public int apply$mcID$sp(double v1) {
                return Function1.apply$mcID$sp$((Function1)this, (double)v1);
            }

            public long apply$mcJD$sp(double v1) {
                return Function1.apply$mcJD$sp$((Function1)this, (double)v1);
            }

            public void apply$mcVD$sp(double v1) {
                Function1.apply$mcVD$sp$((Function1)this, (double)v1);
            }

            public boolean apply$mcZF$sp(float v1) {
                return Function1.apply$mcZF$sp$((Function1)this, (float)v1);
            }

            public double apply$mcDF$sp(float v1) {
                return Function1.apply$mcDF$sp$((Function1)this, (float)v1);
            }

            public float apply$mcFF$sp(float v1) {
                return Function1.apply$mcFF$sp$((Function1)this, (float)v1);
            }

            public int apply$mcIF$sp(float v1) {
                return Function1.apply$mcIF$sp$((Function1)this, (float)v1);
            }

            public long apply$mcJF$sp(float v1) {
                return Function1.apply$mcJF$sp$((Function1)this, (float)v1);
            }

            public void apply$mcVF$sp(float v1) {
                Function1.apply$mcVF$sp$((Function1)this, (float)v1);
            }

            public boolean apply$mcZI$sp(int v1) {
                return Function1.apply$mcZI$sp$((Function1)this, (int)v1);
            }

            public double apply$mcDI$sp(int v1) {
                return Function1.apply$mcDI$sp$((Function1)this, (int)v1);
            }

            public float apply$mcFI$sp(int v1) {
                return Function1.apply$mcFI$sp$((Function1)this, (int)v1);
            }

            public int apply$mcII$sp(int v1) {
                return Function1.apply$mcII$sp$((Function1)this, (int)v1);
            }

            public long apply$mcJI$sp(int v1) {
                return Function1.apply$mcJI$sp$((Function1)this, (int)v1);
            }

            public void apply$mcVI$sp(int v1) {
                Function1.apply$mcVI$sp$((Function1)this, (int)v1);
            }

            public boolean apply$mcZJ$sp(long v1) {
                return Function1.apply$mcZJ$sp$((Function1)this, (long)v1);
            }

            public double apply$mcDJ$sp(long v1) {
                return Function1.apply$mcDJ$sp$((Function1)this, (long)v1);
            }

            public float apply$mcFJ$sp(long v1) {
                return Function1.apply$mcFJ$sp$((Function1)this, (long)v1);
            }

            public int apply$mcIJ$sp(long v1) {
                return Function1.apply$mcIJ$sp$((Function1)this, (long)v1);
            }

            public long apply$mcJJ$sp(long v1) {
                return Function1.apply$mcJJ$sp$((Function1)this, (long)v1);
            }

            public void apply$mcVJ$sp(long v1) {
                Function1.apply$mcVJ$sp$((Function1)this, (long)v1);
            }

            public <A> Function1<A, InputStream> compose(Function1<A, ApplicationConfig> g) {
                return Function1.compose$((Function1)this, g);
            }

            public String toString() {
                return Function1.toString$((Function1)this);
            }

            public boolean isDefinedAt(ApplicationConfig config) {
                return config.fileName().matches(this.fileNameRegex$1);
            }

            public InputStream apply(ApplicationConfig config) {
                InputStream inputStream;
                JsonActivators jsonActivators = new JsonActivators();
                ByteArrayInputStream stream = new ByteArrayInputStream(config.originalBytes());
                this.$outer.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(27).append("File [").append(config.fileName()).append("] recognized as ").append($this.kind$1).append(" file").toString());
                JsonNode documentNode = this.objectMapper$1.readTree((InputStream)stream);
                if (jsonActivators.checkActivators(this.objectMapper$1, documentNode, this.$outer.activators())) {
                    this.$outer.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(57).append("Activations matched for ci [").append(config.ci()).append("] so proceeding with applying").toString());
                    inputStream = (InputStream)this.applyPatch$1.apply((Object)this.$outer.patches(), (Object)documentNode);
                } else {
                    this.$outer.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(48).append("Activations not matched for ci [").append(config.ci()).append("]. Not applying.").toString());
                    inputStream = new ByteArrayInputStream(config.originalBytes());
                }
                return inputStream;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.fileNameRegex$1 = fileNameRegex$1;
                this.kind$1 = kind$1;
                this.objectMapper$1 = objectMapper$1;
                this.applyPatch$1 = applyPatch$1;
                Function1.$init$((Function1)this);
                PartialFunction.$init$((PartialFunction)this);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$apply$1(com.xebialabs.deployit.plugin.JsonPatchDictionary$$anon$1 com.xebialabs.deployit.plugin.JsonPatchDictionary$ApplicationConfig ), $anonfun$apply$2(com.xebialabs.deployit.plugin.JsonPatchDictionary$ApplicationConfig ), $anonfun$apply$3(com.xebialabs.deployit.plugin.JsonPatchDictionary$ApplicationConfig )}, serializedLambda);
            }
        };
    }

    public InputStream apply(InputStream inputStream, ConfigurationItem ci) {
        JsonPatch jsonPatch = new JsonPatch();
        YamlPatch yamlPatch = new YamlPatch();
        return (InputStream)Option$.MODULE$.apply((Object)ci).filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)JsonPatchDictionary.$anonfun$apply$4(x$1))).map((Function1 & Serializable & scala.Serializable)current -> {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            IOUtils.copy((InputStream)inputStream, (OutputStream)out);
            DeployableArtifact artifact = (DeployableArtifact)current;
            String filename = artifact.getFile().getName();
            return (InputStream)this.applyIfMatches("JSON", this.jsonFileRegex(), this.jsonMapper(), (Function2<String, JsonNode, InputStream>)(Function2 & Serializable & scala.Serializable)(patchInput, sourceJsonObj) -> jsonPatch.applyPatchOnJson(patchInput, sourceJsonObj)).orElse(this.applyIfMatches("YAML", this.yamlFileRegex(), this.yamlMapper(), (Function2<String, JsonNode, InputStream>)(Function2 & Serializable & scala.Serializable)(patchInput, jsonNode) -> yamlPatch.applyPatchOnYaml(patchInput, jsonNode))).applyOrElse((Object)new ApplicationConfig(this, filename, (ConfigurationItem)current, out.toByteArray()), (Function1 & Serializable & scala.Serializable)x$2 -> {
                throw new Exception("Unsupported file type. Should be JSON or YAML. Is the file extension correct?");
            });
        }).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(54).append("Patch dictionary can not be applied for ci ").append(ci).append(" with type ").append(Option$.MODULE$.apply((Object)ci).map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.getType()).getOrElse((Function0 & Serializable & scala.Serializable)() -> "unknown")).toString());
            return inputStream;
        });
    }

    public void setPatches(String patches) {
        this.patches_$eq(patches);
    }

    public void setActivators(String activators) {
        this.activators_$eq(activators);
    }

    private final void ApplicationConfig$lzycompute$1() {
        JsonPatchDictionary jsonPatchDictionary = this;
        synchronized (jsonPatchDictionary) {
            if (this.ApplicationConfig$module == null) {
                this.ApplicationConfig$module = new JsonPatchDictionary$ApplicationConfig$(this);
            }
        }
    }

    public static final /* synthetic */ boolean $anonfun$apply$4(ConfigurationItem x$1) {
        return x$1.getType().instanceOf(Type.valueOf(DeployableArtifact.class));
    }

    public JsonPatchDictionary() {
        Logging.$init$((Logging)this);
        JsonSupport.$init$((JsonSupport)this);
        this.patches = new String();
        this.activators = new String();
        this.jsonFileRegex = new String();
        this.yamlFileRegex = new String();
        this.sourceType = SourceType.Packages;
        this.packages = new HashSet<String>();
        this.customFileType = SampleFileType.JSON;
        this.customSample = new String();
        this.selectedArtifact = "";
        this.selectedDocument = "";
    }

    public class ApplicationConfig
    implements Product,
    scala.Serializable {
        private final String fileName;
        private final ConfigurationItem ci;
        private final byte[] originalBytes;
        public final /* synthetic */ JsonPatchDictionary $outer;

        public String fileName() {
            return this.fileName;
        }

        public ConfigurationItem ci() {
            return this.ci;
        }

        public byte[] originalBytes() {
            return this.originalBytes;
        }

        public ApplicationConfig copy(String fileName, ConfigurationItem ci, byte[] originalBytes) {
            return new ApplicationConfig(this.com$xebialabs$deployit$plugin$JsonPatchDictionary$ApplicationConfig$$$outer(), fileName, ci, originalBytes);
        }

        public String copy$default$1() {
            return this.fileName();
        }

        public ConfigurationItem copy$default$2() {
            return this.ci();
        }

        public byte[] copy$default$3() {
            return this.originalBytes();
        }

        public String productPrefix() {
            return "ApplicationConfig";
        }

        public int productArity() {
            return 3;
        }

        public Object productElement(int x$1) {
            Object object;
            int n = x$1;
            switch (n) {
                case 0: {
                    object = this.fileName();
                    break;
                }
                case 1: {
                    object = this.ci();
                    break;
                }
                case 2: {
                    object = this.originalBytes();
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
                }
            }
            return object;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof ApplicationConfig;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof ApplicationConfig)) return false;
            if (((ApplicationConfig)object).com$xebialabs$deployit$plugin$JsonPatchDictionary$ApplicationConfig$$$outer() != this.com$xebialabs$deployit$plugin$JsonPatchDictionary$ApplicationConfig$$$outer()) return false;
            boolean bl = true;
            if (!bl) return false;
            ApplicationConfig applicationConfig = (ApplicationConfig)x$1;
            String string = this.fileName();
            String string2 = applicationConfig.fileName();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            ConfigurationItem configurationItem = this.ci();
            ConfigurationItem configurationItem2 = applicationConfig.ci();
            if (configurationItem == null) {
                if (configurationItem2 != null) {
                    return false;
                }
            } else if (!configurationItem.equals(configurationItem2)) return false;
            if (this.originalBytes() != applicationConfig.originalBytes()) return false;
            if (!applicationConfig.canEqual(this)) return false;
            return true;
        }

        public /* synthetic */ JsonPatchDictionary com$xebialabs$deployit$plugin$JsonPatchDictionary$ApplicationConfig$$$outer() {
            return this.$outer;
        }

        public ApplicationConfig(JsonPatchDictionary $outer, String fileName, ConfigurationItem ci, byte[] originalBytes) {
            this.fileName = fileName;
            this.ci = ci;
            this.originalBytes = originalBytes;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            Product.$init$((Product)this);
        }
    }
}

