package com.xebialabs.xldeploy.provisioner;

import com.xebialabs.deployit.plugin.api.reflect.PropertyKind;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.validation.ApplicableTo;
import com.xebialabs.deployit.plugin.api.validation.Rule;
import com.xebialabs.deployit.plugin.api.validation.ValidationContext;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

@Retention(RetentionPolicy.RUNTIME)
@Rule(clazz = TemplateHostValidator.Validator.class, type = "templateHost")
@ApplicableTo({PropertyKind.CI})
@Target(ElementType.FIELD)
public @interface TemplateHostValidator {

    class Validator implements com.xebialabs.deployit.plugin.api.validation.Validator<ConfigurationItem> {

        @Override
        public void validate(ConfigurationItem ci, ValidationContext context) {
            if (ci == null) return;

            Type templateHostType = Type.valueOf("template.overthere.Host");

            if (!ci.getType().getDescriptor().isAssignableTo(templateHostType)) {
                context.error("Configuration item %s must extend type %s", ci.getId(), templateHostType);
            }
        }
    }
}
