/**
  * Copyright © 2014-2016 XebiaLabs B.V. and its affiliates. Use is subject to terms of the enclosed Legal Notice.
  */
package com.xebialabs.xldeploy.provisioner

import com.xebialabs.deployit.plugin.api.udm._
import com.xebialabs.deployit.plugin.api.udm.base.BaseConfigurationItem
import com.xebialabs.xlplatform.documentation.PublicApiRef

@PublicApiRef
@SuppressWarnings(Array("serial"))
@Metadata(virtual = true, description = "Base type for all generated template CIs.")
@TypeIcon("icons/types/upm.Template.svg")
class Template extends BaseConfigurationItem {

  @Property(required = false, category = "Template", description = "The name that the created instance of this template will have. If not specified, the instance name will be generated based on template name, cardinality and provisioned environment name")
  var instanceName: String = null

  @Property(required = false, description = "Child templates associated with this template.", asContainment = true, category = "Template")
  var childTemplates: JSet[Template] = new JHashSet[Template]()

}
