package com.xebialabs.xldeploy.provisioner.api

import com.xebialabs.xldeploy.provisioner._
import spray.json.DefaultJsonProtocol._
import spray.json.{JsValue, RootJsonFormat, JsonFormat}

import scala.collection.Set
import scala.collection.convert.wrapAll._


object JavaCollectionJsFormat {

  def javaListFormat[T: JsonFormat]: JsonFormat[JList[T]] = new RootJsonFormat[JList[T]] {
    val scalaListFormat: RootJsonFormat[List[T]] = listFormat[T]

    override def read(json: JsValue): JList[T] = new JArrayList(scalaListFormat.read(json))

    override def write(obj: JList[T]): JsValue = scalaListFormat.write(obj.toList)
  }

  def javaSetFormat[T: JsonFormat]: JsonFormat[JSet[T]] = new RootJsonFormat[JSet[T]] {
    val scalaSetFormat: RootJsonFormat[Set[T]] = setFormat[T]

    override def read(json: JsValue): JSet[T] = new JHashSet(scalaSetFormat.read(json))

    override def write(obj: JSet[T]): JsValue = scalaSetFormat.write(obj.toSet)
  }

  def javaMapFormat[K: JsonFormat, V: JsonFormat]: JsonFormat[JMap[K, V]] = new RootJsonFormat[JMap[K, V]] {
    val scalaMapFormat: RootJsonFormat[Map[K, V]] = mapFormat[K, V]

    override def read(json: JsValue): JMap[K, V] = new JHashMap(scalaMapFormat.read(json))

    override def write(obj: JMap[K, V]): JsValue = scalaMapFormat.write(obj.toMap)
  }

}
