package com.xebialabs.xldeploy.provisioner.orchestrator

import com.xebialabs.deployit.engine.spi.orchestration.{Orchestration, Orchestrations, Orchestrator}
import com.xebialabs.deployit.plugin.api.deployment.specification.DeltaSpecification

@Orchestrator.Metadata(name = "provisioning")
class DefaultOrchestrator extends Orchestrator with ProvisionOnly {
  override def orchestrate(specification: DeltaSpecification): Orchestration = {
    checkContainsProvisionedBlueprint(specification)
    Orchestrations.interleaved(descriptionBasedOnSpec(specification), specification.getDeltas)
  }
}
