#
# Copyright (c) 2021. All rights reserved.
# This software and all trademarks, trade names, and logos included herein are the property of Digital.ai, Inc. and its affiliates, subsidiaries, and licensors.
#

from terraxld.api import TFE
from com.xebialabs.overthere.local import LocalConnection
import tarfile
import sys


class TarHelper(object):

    def tar(self, target_tar_file, directory):
        tar = tarfile.open(target_tar_file, "w:gz")
        tar.add(directory, arcname='.')
        tar.close()

    def dump(self, target_tar_file, stream=sys.stdout):
        tar = tarfile.open(target_tar_file, "r:gz")
        for m in tar.getmembers():
            stream.write(m.name)
            stream.write("\n")


archive_file = LocalConnection.getLocalConnection().getTempFile("tfe-xld.tgz")

helper = TarHelper()
helper.tar(archive_file.path, work_dir)

print("TGZ:" + archive_file.path)
helper.dump(archive_file.path)

myapi = TFE(organization)
ws_id = myapi.workspaces.get_id(workspace)

config_version = myapi.config_versions.create(ws_id)
if 'data' not in config_version:
    raise Exception(
        "Cannot create a new config_version. Have you used an Organization API tokens instead of a User or Team token ? Organization API tokens are designed for creating and configuring workspaces and teams. {0}".format(
            config_version))

cv_id = config_version['data']['id']
print("New configuration version {0}".format(cv_id))

print("Upload the tgz")
myapi.config_versions.upload(archive_file.path, cv_id)
context.setAttribute(ws_id + "_cv_id", cv_id)

print("Clean up {0}".format(work_dir))
LocalConnection.getLocalConnection().getFile(work_dir).deleteRecursively()
