#
# Copyright (c) 2021. All rights reserved.
# This software and all trademarks, trade names, and logos included herein are the property of Digital.ai, Inc. and its affiliates, subsidiaries, and licensors.
#


from java.lang import System
from terraxld.api import TFE
import os
import sys
import json
import time


def dump_json(data, message):
    if True:
        print(50 * '=')
        print(message)
        print(50 * '=')
        json.dump(data, sys.stdout, indent=4)
        print(50 * '=')


def stream_plan_output(myapi, run_id, message):
    # TODO: use the stream api to dump the archivist logs continuously
    print(50 * '=')
    print(message)
    print(50 * '=')
    s_plan = myapi.runs.show_plan(run_id)
    status = s_plan['data']['attributes']['status']
    archivist_url = s_plan['data']['attributes']['log-read-url']
    while status == 'running':
        print
        "--> status {0}".format(status)
        time.sleep(5)
        s_plan = myapi.runs.show_plan(run_id)
        status = s_plan['data']['attributes']['status']

    print(50 * '=')
    if status == 'errored':
        [sys.stderr.write(line + "\n") for line in myapi.runs.show_plan_log(run_id).split('\n')]
        raise Exception("Error during the plan phase")
    if status == 'finished':
        print(myapi.runs.show_plan_log(run_id))
    print(50 * '=')


def stream_apply_output(myapi, run_id, message):
    # TODO: use the stream api to dump the archivist logs continuously
    print(50 * '=')
    print(message)
    print(50 * '=')
    s_apply = myapi.runs.show_apply(run_id)
    status = s_apply['data']['attributes']['status']
    archivist_url = s_apply['data']['attributes']['log-read-url']
    while status == 'running':
        print("--> status {0}".format(status))
        time.sleep(5)
        s_apply = myapi.runs.show_apply(run_id)
        status = s_apply['data']['attributes']['status']

    print(50 * '=')
    if status == 'errored':
        [sys.stderr.write(line + "\n") for line in myapi.runs.show_apply_log(run_id).split('\n')]
        raise Exception("Error during the Apply phase")
    if status == 'finished':
        print(myapi.runs.show_apply_log(run_id))
    print(50 * '=')


myapi = TFE(organization)
ws_id = myapi.workspaces.get_id(workspace)
run_id = context.getAttribute(ws_id + "_run_id")
print(run_id)
while True:
    show_result = myapi.runs.show(run_id)
    # dump_json(show_result,"show_result")
    run = show_result['data']
    # dump_json(run,"run")
    run_status = run['attributes']['status']
    print("run_status: {0}     {1}".format(run_id, run_status))

    if run_status == 'planning':
        stream_plan_output(myapi, run_id, "Plan Log {0}/{1}".format(run_status, run_id))

    if run_status == 'applying':
        stream_apply_output(myapi, run_id, "Apply Log {0}/{1}".format(run_status, run_id))

    if run_status == 'applied' or run_status == 'planned_and_finished':
        print("done")
        break
    elif run_status == 'errored' or run_status == 'canceled' or run_status == 'policy_soft_failed':
        stream_plan_output(myapi, run_id, "Plan Log {0}/{1}".format(run_status, run_id))
        raise Exception("An error occured in  {0}".format(run_id))

    time.sleep(1)
