#
# Copyright (c) 2021. All rights reserved.
# This software and all trademarks, trade names, and logos included herein are the property of Digital.ai, Inc. and its affiliates, subsidiaries, and licensors.
#

from terraform.mapper.resource_mapper import ResourceMapper


class AWSS3Mapper(ResourceMapper):
    def __init__(self):
        super(AWSS3Mapper, self).__init__(["aws.Cloud", "aws.s3.Bucket"])

    def accepted_types(self):
        return ['aws_s3_bucket']

    def create_ci(self, tf_resources, folder, deployed):
        cis = []
        for tf_resource in tf_resources:
            if not self.types_supported(tf_resource['type']):
                return None
            attributes = tf_resource['attributes']
            print("Creating CI of type 'aws.Cloud")
            aws_id = "{0}/{1}".format(folder, "MyAWS")
            print(aws_id)
            if deployed.container.type == 'terraformEnterprise.AwsProvider':
                aws_properties = {
                    'accesskey': deployed.container.accessKey,
                    'accessSecret': deployed.container.accessSecret
                }
            else:
                aws_properties = {
                    'accesskey': deployed.container.credentials['AWS_ACCESS_KEY_ID'],
                    'accessSecret': deployed.container.credentials['AWS_SECRET_ACCESS_KEY']
                }

            s3_id = "{0}/{1}".format(aws_id, attributes['bucket_domain_name'])
            # print s3_id
            s3_bucket_properties = {'bucketName': attributes['bucket'], 'region': attributes['region']}
            # print s3_bucket_properties
            cis.extend([
                super(AWSS3Mapper, self)._create_ci("aws.Cloud", aws_id, aws_properties),
                super(AWSS3Mapper, self)._create_ci("aws.s3.Bucket", s3_id, s3_bucket_properties)
            ])
        return cis
