<#assign workingDirectory='${deployed.container.workingDirectory}\\${deployed.name}'/>

<#assign init_args='-input=false -no-color'/>

<#if deployed.container.pluginDirectory??>
    <#assign init_args='-plugin-dir \"${deployed.container.pluginDirectory}\"'/>
</#if>

<#assign args='-input=false -no-color'/>

<#if deployed.parallelism??>
    <#assign args='${args} -parallelism=${deployed.parallelism}'/>
</#if>

<#if deployed.targets??>
    <#list deployed.targets as target>
        <#assign args='${args} -target=${target}'/>
    </#list>
</#if>

<#if deployed.inputVariables??>
    <#list deployed.inputVariables?keys as key>
        <#assign args="${args} -var ${key}=\"${deployed.inputVariables[key]?j_string}\""/>
    </#list>
</#if>

<#assign args_obfuscated="${args}"/>

<#if deployed.secretInputVariables??>
    <#list deployed.secretInputVariables?keys as key>
        <#assign args="${args} -var ${key}=\"${deployed.secretInputVariables[key]?j_string}\""/>
        <#assign args_obfuscated="${args_obfuscated} -var ${key}=\"********\""/>
    </#list>
</#if>

<#assign terraform_init="\"${deployed.container.path}\\terraform.exe\" init ${init_args}" />
<#assign terraform_plan="\"${deployed.container.path}\\terraform.exe\" plan -lock=false ${args}" />

@echo off
set TF_IN_AUTOMATION=true

mkdir -p "${workingDirectory}"
cd /d "${workingDirectory}"

echo "Cleaning up working directory and copying scripts from ${deployed.file.path} to ${workingDirectory}"
robocopy . temp_pit /XF *.tfstate /S /MOVE /NFL /NDL /NJH /NJS /nc /ns /np > NUL
rmdir temp_pit /S /Q
robocopy "${deployed.file.path}" "${workingDirectory}" /E /NFL /NDL /NJH /NJS /nc /ns /np > NUL

${terraform_init} > NUL
IF %ERRORLEVEL% NEQ 0 exit /b 1

${terraform_plan}
