from terraform.overthere_connection_builder import OverthereConnectionBuilder
import com.xebialabs.deployit.plugin.terraform.CaptureOutputHandler as CaptureOutputHandler
import json

builder = OverthereConnectionBuilder()

def capture_output(command, deployed):
    connection = builder.get_connection(deployed.container.host._delegate)
    working_directory = "{}{}{}".format(deployed.container.workingDirectory, deployed.container.host.os.fileSeparator, deployed.name)

    connection.setWorkingDirectory(connection.getFile(working_directory))
    output_handler = CaptureOutputHandler()

    connection.execute(output_handler, None, command)
    return output_handler.getOutput()
