from terraform.capture_output import capture_output
import com.xebialabs.overthere.CmdLine as CmdLine
import json
from terraform.mapper.gke_cluster_mapper import GKEClusterMapper
from terraform.mapper.aks_cluster_mapper import AKSClusterMapper
from com.xebialabs.deployit.provision import ProvisionHelper

command = CmdLine.build("{}{}terraform".format(deployed.container.path, deployed.container.host.os.fileSeparator), "state", "pull")
output = capture_output(command, deployed)

resource_mappers = {
    'google_container_cluster': GKEClusterMapper(),
    'azurerm_kubernetes_cluster': AKSClusterMapper()
}
host_id = deployed.container.host.id
folder = host_id[:host_id.rfind('/')+1]
generated_cis = []
generated_ids = []
if output:
    output_variables = {}
    output_json = json.loads(output)
    modules = output_json['modules']

    if modules:
        for module in modules:
            resources = module['resources']
            if resources:
                for resourceKey in resources:
                    resource = resources[resourceKey]
                    if resource['type'] in resource_mappers:
                        # TODO create CI
                        cis = resource_mappers[resource['type']].create_ci(resource, folder)
                        for ci in cis:
                            if ci is not None:
                                if repositoryService.exists(ci.id):
                                    repositoryService.update(ci.id, ci)
                                    print("'%s' of type '%s' updated from '%s' resource." % (ci.id, ci.type, resource['type']))
                                else:
                                    repositoryService.create(ci.id, ci)
                                    print("'%s' of type '%s' created from '%s' resource." % (ci.id, ci.type, resource['type']))
                                generated_cis.append(ci)
                                generated_ids.append(ci.id)
                    else:
                        context.logOutput("Skipping '%s' as it is not a candidate for infrastructure creation." % resourceKey)
            else:
                context.logOutput("No resources found for '%s', skipping Infrastructure creation." % deployed.name)

    cis_to_delete = []
    if (previousDeployed):
        for ci in previousDeployed.generatedConfigurationItems:
            if ci.type != "udm.Environment" and ci.type != "udm.Dictionary":
                if ci.id not in generated_ids:
                    cis_to_delete.append(ci.id)

    # Update environment members
    environment_id = ProvisionHelper.getProvisionEnvironmentId(deployed.environmentPath, deployedApplication.environment.id)
    environment = ProvisionHelper.getOrCreateEnvironment(environment_id, context)
    members = environment.members
    for ci in generated_cis:
        members.add(ci)
    members_to_remove = []
    for ci in members:
        if ci.id in cis_to_delete:
            print("'%s' removed from 'members' property '%s'" % (ci.id, environment_id))
            members_to_remove.append(ci)
    for ci in members_to_remove:
        members.remove(ci)
    environment.setMembers(members)
    repositoryService.update(environment_id, environment)

    # Update generatedConfigurationItems
    generatedConfigurationItems = deployed.generatedConfigurationItems
    for ci in generated_cis:
        generatedConfigurationItems.add(ci)
    if environment_id != deployedApplication.environment.id:
        generatedConfigurationItems.add(environment)

    generated_to_remove = []
    for ci in generatedConfigurationItems:
        if ci.id in cis_to_delete:
            print("'%s' removed from 'generatedConfigurationItems' property of '%s'" % (ci.id, deployed.id))
            generated_to_remove.append(ci)
    for ci in generated_to_remove:
        generatedConfigurationItems.remove(ci)
    deployed.setGeneratedConfigurationItems(generatedConfigurationItems)
    if repositoryService.exists(deployed.id):
        repositoryService.update(deployed.id, deployed)

    for ci_id in cis_to_delete:
        repositoryService.delete(ci_id)
        print("'%s' deleted" % ci_id)

    else:
        context.logOutput("No modules found for '%s', skipping Infrastructure creation." % deployed.name)
