from sets import Set

to_start = Set()
to_stop = Set()
for delta in deltas.deltas:
    if delta.operation == "NOOP":
        continue
    deployed = delta.deployedOrPrevious
    if deployed.type == "xlrelease.DeployedPlugin":
        to_start.add(deployed.container)
        to_stop.add(deployed.container)
    elif deployed.type == "xlrelease.XLReleaseInstallation":
        if delta.operation in ["CREATE", "MODIFY"]:
            to_start.add(deployed.container)
        if delta.operation in ["MODIFY", "DESTROY"]:
            to_stop.add(deployed.container)

for container in to_stop:
    context.addStep(steps.os_script(
        description="Stop %s" % container.name,
        order=19,
        script="xlrelease/stop-xlrelease",
        freemarker_context={'container': container},
        target_host=container.host
    ))
for container in to_start:
    context.addStep(steps.os_script(
        description="Start %s" % container.name,
        order=80,
        script="xlrelease/start-xlrelease",
        freemarker_context={'container': container},
        target_host=container.host
    ))
