xlr_user=${xlr_user!"xl-release"}
xlr_group=${xlr_group!"xl-release"}

echo Starting the XL Release server
cd ${container.homeDir}/current-version
sleep 7
if [ "$(uname)" == "Darwin" ]; then
	echo "Darwin detected ... skip nohup"
	sudo -u $xlr_user sh -c 'bin/server.sh -force-upgrades >>nohup.out 2>&1 &'
else
	sudo -u $xlr_user nohup sh -c 'bin/server.sh -force-upgrades >>nohup.out 2>&1 &'
fi

COUNT=120
url="http://localhost:${container.port}"
while [ $COUNT -gt 0 ]; do
	sleep 2
	if curl --output /dev/null --silent --head --fail "$url"; then
	  echo "XL Release has started on port ${container.port}"
	  exit 0
	else
	  echo "Waiting for XL Release to start on port ${container.port} ..."
	fi
    COUNT=$((COUNT-1))
done
echo "XL Release did not start in 4 minutes, please check its log files or try again"
exit 1
