/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.overthere.ssh;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.io.Closeables;
import com.xebialabs.overthere.OverthereFile;
import com.xebialabs.overthere.RuntimeIOException;
import com.xebialabs.overthere.ssh.SshFile;
import com.xebialabs.overthere.ssh.SshSftpConnection;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import net.schmizz.sshj.sftp.FileAttributes;
import net.schmizz.sshj.sftp.FileMode;
import net.schmizz.sshj.sftp.OpenMode;
import net.schmizz.sshj.sftp.RemoteFile;
import net.schmizz.sshj.sftp.RemoteResourceInfo;
import net.schmizz.sshj.xfer.FilePermission;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SshSftpFile
extends SshFile<SshSftpConnection> {
    private static Logger logger = LoggerFactory.getLogger(SshSftpFile.class);

    public SshSftpFile(SshSftpConnection connection, String path) {
        super(connection, path);
    }

    protected String getSftpPath() {
        return ((SshSftpConnection)this.connection).pathToSftpPath(this.getPath());
    }

    @Override
    public boolean exists() {
        logger.debug("Checking file " + this + " for existence");
        try {
            return ((SshSftpConnection)this.connection).getSharedSftpClient().statExistence(this.getSftpPath()) != null;
        }
        catch (IOException e) {
            throw new RuntimeIOException("Cannot check existence of file " + this.getPath(), e);
        }
    }

    @Override
    public boolean isFile() {
        return this.stat().getType() == FileMode.Type.REGULAR;
    }

    @Override
    public boolean isDirectory() {
        return this.stat().getType() == FileMode.Type.DIRECTORY;
    }

    @Override
    public long lastModified() {
        return this.stat().getMtime();
    }

    @Override
    public long length() {
        return this.stat().getSize();
    }

    @Override
    public boolean canRead() {
        return this.hasPermission(FilePermission.USR_R);
    }

    @Override
    public boolean canWrite() {
        return this.hasPermission(FilePermission.USR_W);
    }

    @Override
    public boolean canExecute() {
        return this.hasPermission(FilePermission.USR_X);
    }

    private boolean hasPermission(FilePermission perm) {
        return this.stat().getPermissions().contains(perm);
    }

    protected FileAttributes stat() {
        logger.debug("Statting file " + this);
        try {
            return ((SshSftpConnection)this.connection).getSharedSftpClient().stat(this.getSftpPath());
        }
        catch (IOException e) {
            throw new RuntimeIOException("Cannot stat file " + this, e);
        }
    }

    @Override
    public List<OverthereFile> listFiles() {
        logger.debug("Listing files in {}", (Object)this);
        try {
            List ls = ((SshSftpConnection)this.connection).getSharedSftpClient().ls(this.getSftpPath());
            ArrayList files = Lists.newArrayList();
            for (RemoteResourceInfo l : ls) {
                String filename = l.getName();
                if (filename.equals(".") || filename.equals("..")) continue;
                files.add(this.getFile(filename));
            }
            return files;
        }
        catch (IOException e) {
            throw new RuntimeIOException("Cannot list directory " + this, e);
        }
    }

    @Override
    public void mkdir() {
        logger.debug("Creating directory " + this);
        try {
            ((SshSftpConnection)this.connection).getSharedSftpClient().mkdir(this.getSftpPath());
        }
        catch (IOException e) {
            throw new RuntimeIOException("Cannot create directory " + this, e);
        }
    }

    @Override
    public void mkdirs() {
        logger.debug("Creating directories {}", (Object)this);
        try {
            ((SshSftpConnection)this.connection).getSharedSftpClient().mkdirs(this.getSftpPath());
        }
        catch (IOException e) {
            throw new RuntimeIOException("Cannot create directories " + this, e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void renameTo(OverthereFile dest) {
        logger.debug("Renaming {} to {}", (Object)this, (Object)dest);
        if (!(dest instanceof SshSftpFile)) throw new RuntimeIOException("Cannot move/rename ssh:" + ((SshSftpConnection)this.connection).sshConnectionType.toString().toLowerCase() + ": file/directory " + this + " to non-ssh:" + ((SshSftpConnection)this.connection).sshConnectionType.toString().toLowerCase() + ": file/directory " + dest);
        SshSftpFile sftpDest = (SshSftpFile)dest;
        if (sftpDest.getConnection() != this.getConnection()) throw new RuntimeIOException("Cannot move/rename ssh:" + ((SshSftpConnection)this.connection).sshConnectionType.toString().toLowerCase() + ": file/directory " + this + " to file/directory " + dest + " because it is in a different connection");
        try {
            ((SshSftpConnection)this.connection).getSharedSftpClient().rename(this.getSftpPath(), sftpDest.getSftpPath());
            return;
        }
        catch (IOException e) {
            throw new RuntimeIOException("Cannot move/rename file/directory " + this + " to " + dest, e);
        }
    }

    @Override
    public void setExecutable(boolean executable) {
        logger.debug("Setting execute permission on {} to {}", (Object)this, (Object)executable);
        try {
            int permissionsMask = ((SshSftpConnection)this.connection).getSharedSftpClient().stat(this.getSftpPath()).getMode().getPermissionsMask();
            permissionsMask = executable ? (permissionsMask |= 0x49) : (permissionsMask &= 0xFFFFFFB6);
            ((SshSftpConnection)this.connection).getSharedSftpClient().chmod(this.getPath(), permissionsMask);
        }
        catch (IOException e) {
            throw new RuntimeIOException("Cannot delete file " + this, e);
        }
    }

    @Override
    protected void deleteFile() {
        logger.debug("Removing file {}", (Object)this);
        try {
            ((SshSftpConnection)this.connection).getSharedSftpClient().rm(this.getSftpPath());
        }
        catch (IOException e) {
            throw new RuntimeIOException("Cannot delete file " + this, e);
        }
    }

    @Override
    protected void deleteDirectory() {
        logger.debug("Removing directory {}", (Object)this);
        try {
            ((SshSftpConnection)this.connection).getSharedSftpClient().rmdir(this.getSftpPath());
        }
        catch (IOException e) {
            throw new RuntimeIOException("Cannot delete directory " + this, e);
        }
    }

    @Override
    public InputStream getInputStream() {
        logger.debug("Opening SFTP input stream to read from file {}", (Object)this);
        try {
            final RemoteFile remoteFile = ((SshSftpConnection)this.connection).getSharedSftpClient().open(this.getSftpPath(), (Set)Sets.newHashSet((Object[])new OpenMode[]{OpenMode.READ}));
            final RemoteFile.RemoteFileInputStream stream = remoteFile.getInputStream();
            return new InputStream(){

                @Override
                public int read() throws IOException {
                    return stream.read();
                }

                @Override
                public int read(byte[] b) throws IOException {
                    return stream.read(b);
                }

                @Override
                public int read(byte[] b, int off, int len) throws IOException {
                    return stream.read(b, off, len);
                }

                @Override
                public long skip(long n) throws IOException {
                    return stream.skip(n);
                }

                @Override
                public int available() throws IOException {
                    return stream.available();
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void close() throws IOException {
                    try {
                        super.close();
                    }
                    finally {
                        Closeables.closeQuietly((Closeable)remoteFile);
                    }
                }

                @Override
                public void mark(int readlimit) {
                    stream.mark(readlimit);
                }

                @Override
                public void reset() throws IOException {
                    stream.reset();
                }

                @Override
                public boolean markSupported() {
                    return stream.markSupported();
                }
            };
        }
        catch (IOException e) {
            throw new RuntimeIOException("Cannot read from file " + this, e);
        }
    }

    @Override
    public OutputStream getOutputStream() {
        logger.debug("Opening SFTP ouput stream to write to file {}", (Object)this);
        try {
            RemoteFile remoteFile = ((SshSftpConnection)this.connection).getSharedSftpClient().open(this.getSftpPath(), (Set)Sets.newHashSet((Object[])new OpenMode[]{OpenMode.CREAT, OpenMode.WRITE, OpenMode.TRUNC}));
            RemoteFile.RemoteFileOutputStream wrapped = remoteFile.getOutputStream();
            return new OutputStream((OutputStream)wrapped, remoteFile){
                final /* synthetic */ OutputStream val$wrapped;
                final /* synthetic */ RemoteFile val$remoteFile;
                {
                    this.val$wrapped = outputStream;
                    this.val$remoteFile = remoteFile;
                }

                @Override
                public void write(int b) throws IOException {
                    this.val$wrapped.write(b);
                }

                @Override
                public void write(byte[] b) throws IOException {
                    this.val$wrapped.write(b);
                }

                @Override
                public void write(byte[] b, int off, int len) throws IOException {
                    this.val$wrapped.write(b, off, len);
                }

                @Override
                public void flush() throws IOException {
                    this.val$wrapped.flush();
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void close() throws IOException {
                    try {
                        this.val$wrapped.close();
                    }
                    finally {
                        Closeables.closeQuietly((Closeable)this.val$remoteFile);
                    }
                }
            };
        }
        catch (IOException e) {
            throw new RuntimeIOException("Cannot write to file " + this, e);
        }
    }
}

