/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.query.lucene;

import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.jcr.ItemNotFoundException;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.query.RowIterator;
import org.apache.jackrabbit.api.query.JackrabbitQueryResult;
import org.apache.jackrabbit.core.query.lucene.AbstractQueryImpl;
import org.apache.jackrabbit.core.query.lucene.CloseableHits;
import org.apache.jackrabbit.core.query.lucene.DocOrderScoreNodeIterator;
import org.apache.jackrabbit.core.query.lucene.ExcerptProvider;
import org.apache.jackrabbit.core.query.lucene.IOCounters;
import org.apache.jackrabbit.core.query.lucene.MultiColumnQueryHits;
import org.apache.jackrabbit.core.query.lucene.NodeIteratorImpl;
import org.apache.jackrabbit.core.query.lucene.RowIteratorImpl;
import org.apache.jackrabbit.core.query.lucene.ScoreNode;
import org.apache.jackrabbit.core.query.lucene.ScoreNodeIterator;
import org.apache.jackrabbit.core.query.lucene.SearchIndex;
import org.apache.jackrabbit.core.query.lucene.SpellSuggestion;
import org.apache.jackrabbit.core.session.SessionContext;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.commons.query.qom.ColumnImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class QueryResultImpl
implements JackrabbitQueryResult {
    private static final Logger log = LoggerFactory.getLogger(QueryResultImpl.class);
    protected final SearchIndex index;
    protected final SessionContext sessionContext;
    protected final AbstractQueryImpl queryImpl;
    protected final SpellSuggestion spellSuggestion;
    protected final Map<String, ColumnImpl> columns = new LinkedHashMap<String, ColumnImpl>();
    private final List<ScoreNode[]> resultNodes = new ArrayList<ScoreNode[]>();
    private int numResults = -1;
    private Name[] selectorNames;
    private int invalid = 0;
    protected final boolean docOrder;
    private ExcerptProvider excerptProvider;
    private final long offset;
    private final long limit;

    public QueryResultImpl(SearchIndex index, SessionContext sessionContext, AbstractQueryImpl queryImpl, SpellSuggestion spellSuggestion, ColumnImpl[] columns, boolean documentOrder, long offset, long limit) throws RepositoryException {
        this.index = index;
        this.sessionContext = sessionContext;
        this.queryImpl = queryImpl;
        this.spellSuggestion = spellSuggestion;
        this.docOrder = documentOrder;
        this.offset = offset;
        this.limit = limit;
        for (ColumnImpl column : columns) {
            String cn = column.getColumnName();
            if (cn == null) {
                String msg = column + " does not have a column name";
                throw new IllegalArgumentException(msg);
            }
            this.columns.put(cn, column);
        }
    }

    public String[] getSelectorNames() throws RepositoryException {
        String[] names = new String[this.selectorNames.length];
        for (int i = 0; i < this.selectorNames.length; ++i) {
            names[i] = this.sessionContext.getJCRName(this.selectorNames[i]);
        }
        return names;
    }

    public String[] getColumnNames() throws RepositoryException {
        return this.columns.keySet().toArray(new String[this.columns.size()]);
    }

    public NodeIterator getNodes() throws RepositoryException {
        return new NodeIteratorImpl(this.sessionContext, this.getScoreNodes(), 0);
    }

    public RowIterator getRows() throws RepositoryException {
        if (this.excerptProvider == null) {
            try {
                this.excerptProvider = this.createExcerptProvider();
            }
            catch (IOException e) {
                throw new RepositoryException((Throwable)e);
            }
        }
        return new RowIteratorImpl(this.getScoreNodes(), this.columns, this.selectorNames, this.sessionContext.getItemManager(), this.index.getContext().getHierarchyManager(), this.sessionContext, this.sessionContext.getSessionImpl().getValueFactory(), this.excerptProvider, this.spellSuggestion);
    }

    protected abstract MultiColumnQueryHits executeQuery(long var1) throws IOException;

    protected abstract ExcerptProvider createExcerptProvider() throws IOException;

    private ScoreNodeIterator getScoreNodes() {
        if (this.docOrder) {
            return new DocOrderScoreNodeIterator(this.sessionContext.getItemManager(), this.resultNodes, 0);
        }
        return new LazyScoreNodeIteratorImpl();
    }

    protected void getResults(long size) throws RepositoryException {
        if (log.isDebugEnabled()) {
            log.debug("getResults({}) limit={}", (Object)size, (Object)this.limit);
        }
        long maxResultSize = size;
        if (this.limit >= 0L) {
            maxResultSize = this.limit;
        }
        if ((long)this.resultNodes.size() >= maxResultSize && this.selectorNames != null) {
            return;
        }
        CloseableHits result = null;
        try {
            long time = System.currentTimeMillis();
            long r1 = IOCounters.getReads();
            result = this.executeQuery(maxResultSize);
            long r2 = IOCounters.getReads();
            log.debug("query executed in {} ms ({})", (Object)(System.currentTimeMillis() - time), (Object)(r2 - r1));
            this.selectorNames = result.getSelectorNames();
            if (this.resultNodes.isEmpty() && this.offset > 0L) {
                this.collectScoreNodes((MultiColumnQueryHits)result, new ArrayList<ScoreNode[]>(), this.offset);
            } else {
                int start = this.resultNodes.size() + this.invalid + (int)this.offset;
                result.skip(start);
            }
            time = System.currentTimeMillis();
            this.collectScoreNodes((MultiColumnQueryHits)result, this.resultNodes, maxResultSize);
            long r3 = IOCounters.getReads();
            log.debug("retrieved ScoreNodes in {} ms ({})", (Object)(System.currentTimeMillis() - time), (Object)(r3 - r2));
            this.numResults = result.getSize();
        }
        catch (IOException e) {
            throw new RepositoryException((Throwable)e);
        }
        finally {
            if (result != null) {
                try {
                    result.close();
                }
                catch (IOException e) {
                    log.warn("Unable to close query result: " + e);
                }
            }
        }
    }

    private void collectScoreNodes(MultiColumnQueryHits hits, List<ScoreNode[]> collector, long maxResults) throws IOException, RepositoryException {
        ScoreNode[] sn;
        while ((long)collector.size() < maxResults && (sn = hits.nextScoreNodes()) != null) {
            if (this.isAccessGranted(sn)) {
                collector.add(sn);
                continue;
            }
            ++this.invalid;
        }
    }

    private boolean isAccessGranted(ScoreNode[] nodes) throws RepositoryException {
        for (ScoreNode node : nodes) {
            try {
                if (node == null || this.sessionContext.getAccessManager().canRead(null, node.getNodeId())) continue;
                return false;
            }
            catch (ItemNotFoundException e) {
                // empty catch block
            }
        }
        return true;
    }

    public int getTotalSize() {
        if (this.numResults == -1) {
            return -1;
        }
        return this.numResults - this.invalid;
    }

    private final class LazyScoreNodeIteratorImpl
    implements ScoreNodeIterator {
        private int position = -1;
        private boolean initialized = false;
        private ScoreNode[] next;

        private LazyScoreNodeIteratorImpl() {
        }

        @Override
        public ScoreNode[] nextScoreNodes() {
            this.initialize();
            if (this.next == null) {
                throw new NoSuchElementException();
            }
            ScoreNode[] sn = this.next;
            this.fetchNext();
            return sn;
        }

        public void skip(long skipNum) {
            this.initialize();
            if (skipNum < 0L) {
                throw new IllegalArgumentException("skipNum must not be negative");
            }
            if (skipNum != 0L) {
                try {
                    QueryResultImpl.this.getResults(this.position + QueryResultImpl.this.invalid + (int)skipNum);
                    if ((long)QueryResultImpl.this.resultNodes.size() < (long)this.position + skipNum) {
                        throw new NoSuchElementException();
                    }
                    this.position = (int)((long)this.position + (skipNum - 1L));
                    this.fetchNext();
                }
                catch (RepositoryException e) {
                    throw new NoSuchElementException(e.getMessage());
                }
            }
        }

        public long getSize() {
            long size;
            int total = QueryResultImpl.this.getTotalSize();
            if (total == -1) {
                return -1L;
            }
            long l = size = QueryResultImpl.this.offset > (long)total ? 0L : (long)total - QueryResultImpl.this.offset;
            if (QueryResultImpl.this.limit >= 0L && size > QueryResultImpl.this.limit) {
                return QueryResultImpl.this.limit;
            }
            return size;
        }

        public long getPosition() {
            this.initialize();
            return this.position;
        }

        public void remove() {
            throw new UnsupportedOperationException("remove");
        }

        public boolean hasNext() {
            this.initialize();
            return this.next != null;
        }

        public Object next() {
            return this.nextScoreNodes();
        }

        private void initialize() {
            if (!this.initialized) {
                this.fetchNext();
                this.initialized = true;
            }
        }

        private void fetchNext() {
            this.next = null;
            int nextPos = this.position + 1;
            while (this.next == null) {
                if (nextPos >= QueryResultImpl.this.resultNodes.size()) {
                    if (QueryResultImpl.this.numResults != -1 && nextPos + QueryResultImpl.this.invalid >= QueryResultImpl.this.numResults) break;
                    try {
                        int num = QueryResultImpl.this.resultNodes.size() == 0 ? QueryResultImpl.this.index.getResultFetchSize() : QueryResultImpl.this.resultNodes.size() * 2;
                        QueryResultImpl.this.getResults(num);
                    }
                    catch (RepositoryException e) {
                        log.warn("Exception getting more results: " + (Object)((Object)e));
                    }
                    if (nextPos >= QueryResultImpl.this.resultNodes.size()) break;
                }
                this.next = (ScoreNode[])QueryResultImpl.this.resultNodes.get(nextPos);
            }
            ++this.position;
        }
    }
}

