/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.security.authorization;

import javax.jcr.Item;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.util.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class GlobPattern {
    private static Logger log = LoggerFactory.getLogger(GlobPattern.class);
    private static final char WILDCARD_CHAR = '*';
    private static final String WILDCARD_STRING = "*";
    private final String nodePath;
    private final String restriction;
    private final Pattern pattern;

    private GlobPattern(String nodePath, String restriction) {
        if (nodePath == null) {
            throw new IllegalArgumentException();
        }
        this.nodePath = nodePath;
        this.restriction = restriction;
        if (restriction != null && restriction.length() > 0) {
            StringBuilder b = new StringBuilder(nodePath);
            b.append(restriction);
            int lastPos = restriction.lastIndexOf(42);
            if (lastPos >= 0) {
                String end = lastPos != restriction.length() - 1 ? restriction.substring(lastPos + 1) : null;
                this.pattern = new WildcardPattern(b.toString(), end);
            } else {
                this.pattern = new PathPattern(b.toString());
            }
        } else {
            this.pattern = new PathPattern();
        }
    }

    public static GlobPattern create(String nodePath, String restrictions) {
        return new GlobPattern(nodePath, restrictions);
    }

    public static GlobPattern create(String nodePath) {
        return GlobPattern.create(nodePath, null);
    }

    public boolean matches(String toMatch) {
        if (toMatch == null) {
            return false;
        }
        return this.pattern.matches(toMatch);
    }

    public boolean matches(Item itemToMatch) {
        try {
            return this.matches(itemToMatch.getPath());
        }
        catch (RepositoryException e) {
            log.error("Unable to determine match.", (Object)e.getMessage());
            return false;
        }
    }

    public int hashCode() {
        int h = 629 + this.nodePath.hashCode();
        if (this.restriction != null) {
            h = 37 * h + this.restriction.hashCode();
        }
        return h;
    }

    public String toString() {
        return this.nodePath + " : " + this.restriction;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof GlobPattern) {
            GlobPattern other = (GlobPattern)obj;
            return this.nodePath.equals(other.nodePath) && this.restriction == null ? other.restriction == null : this.restriction.equals(other.restriction);
        }
        return false;
    }

    private final class WildcardPattern
    extends Pattern {
        private final String patternEnd;
        private final char[] patternChars;

        private WildcardPattern(String patternStr, String patternEnd) {
            this.patternChars = patternStr.toCharArray();
            this.patternEnd = patternEnd;
        }

        @Override
        boolean matches(String toMatch) {
            if (this.patternEnd != null && !toMatch.endsWith(this.patternEnd)) {
                return false;
            }
            char[] tm = toMatch.endsWith("/") ? toMatch.substring(0, toMatch.length() - 1).toCharArray() : toMatch.toCharArray();
            return this.matches(this.patternChars, 0, tm, 0);
        }

        private boolean matches(char[] pattern, int pOff, char[] s, int sOff) {
            int pLength = pattern.length;
            int sLength = s.length;
            while (pOff < pLength) {
                if (sOff >= sLength && pattern[pOff] != '*') {
                    return false;
                }
                if (pattern[pOff] == '*') {
                    if (++pOff >= pLength) {
                        return true;
                    }
                    while (true) {
                        if (this.matches(pattern, pOff, s, sOff)) {
                            return true;
                        }
                        if (sOff >= sLength) {
                            return false;
                        }
                        ++sOff;
                    }
                }
                if (pOff < pLength && sOff < sLength && pattern[pOff] != s[sOff]) {
                    return false;
                }
                ++pOff;
                ++sOff;
            }
            return sOff >= sLength;
        }
    }

    private final class PathPattern
    extends Pattern {
        private final String patternStr;

        private PathPattern() {
            this((String)null);
        }

        private PathPattern(String patternStr) {
            this.patternStr = patternStr;
        }

        @Override
        boolean matches(String toMatch) {
            if (GlobPattern.this.restriction == null) {
                return Text.isDescendantOrEqual((String)GlobPattern.this.nodePath, (String)toMatch);
            }
            if (GlobPattern.this.restriction.length() == 0) {
                return GlobPattern.this.nodePath.equals(toMatch);
            }
            return Text.isDescendantOrEqual((String)this.patternStr, (String)toMatch);
        }
    }

    private abstract class Pattern {
        private Pattern() {
        }

        abstract boolean matches(String var1);
    }
}

