/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit;

import com.google.common.io.CharStreams;
import com.xebialabs.license.service.LicenseServiceImpl;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Writer;
import javax.servlet.http.HttpServletRequest;
import org.mortbay.jetty.handler.ErrorHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CustomErrorHandler
extends ErrorHandler {
    private static final Logger log = LoggerFactory.getLogger(LicenseServiceImpl.class);
    private String licenseMissingPage = null;

    public void handleErrorPage(HttpServletRequest request, Writer writer, int code, String message) throws IOException {
        if (code != 402) {
            super.handleErrorPage(request, writer, code, message);
            return;
        }
        if (this.licenseMissingPage == null) {
            this.loadMissingLicensePageContents();
        }
        writer.write(this.licenseMissingPage);
    }

    private void loadMissingLicensePageContents() {
        try {
            InputStream inputStream = ((Object)((Object)this)).getClass().getResourceAsStream("error402page.html");
            this.licenseMissingPage = CharStreams.toString((Readable)new InputStreamReader(inputStream));
        }
        catch (IOException ex) {
            this.useDefaultLicensePageContents();
        }
        catch (NullPointerException ex) {
            this.useDefaultLicensePageContents();
        }
    }

    private void useDefaultLicensePageContents() {
        this.licenseMissingPage = "<html>\n    <body>\n    This Deployit server will not function due to a license problem. Either it could not be found,\n    it was not properly readable, or it has expired. See the deployit log files for more information.\n<br/><br/>\n    If you would like to continue using Deployit, please contact your XebiaLabs sales\n    representative for a new license.\n<br/><br/>\n    Regards,<br/>\n    the XebiaLabs team\n    </body>\n</html>";
    }
}

