/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.overthere.cifs.winrm;

import com.google.common.base.Preconditions;
import com.google.common.io.Closeables;
import com.xebialabs.overthere.CmdLine;
import com.xebialabs.overthere.ConnectionOptions;
import com.xebialabs.overthere.OperatingSystemFamily;
import com.xebialabs.overthere.OverthereProcess;
import com.xebialabs.overthere.RuntimeIOException;
import com.xebialabs.overthere.cifs.CifsConnection;
import com.xebialabs.overthere.cifs.CifsConnectionBuilder;
import com.xebialabs.overthere.cifs.WinrmHttpsCertificateTrustStrategy;
import com.xebialabs.overthere.cifs.WinrmHttpsHostnameVerificationStrategy;
import com.xebialabs.overthere.cifs.winrm.WinRmClient;
import com.xebialabs.overthere.cifs.winrm.WinRmRuntimeIOException;
import com.xebialabs.overthere.spi.AddressPortMapper;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.net.MalformedURLException;
import java.net.URL;

public class CifsWinRmConnection
extends CifsConnection {
    private ConnectionOptions options;
    public static final int STDIN_BUF_SIZE = 4096;

    public CifsWinRmConnection(String type, ConnectionOptions options, AddressPortMapper mapper) {
        super(type, options, mapper, true);
        Preconditions.checkArgument((this.os == OperatingSystemFamily.WINDOWS ? 1 : 0) != 0, (String)"Cannot start a cifs:%s connection to a non-Windows operating system", (Object[])new Object[]{this.cifsConnectionType.toString().toLowerCase()});
        Preconditions.checkArgument((!this.username.contains("\\") ? 1 : 0) != 0, (String)"Cannot start a cifs:%s connection with an old-style Windows domain account [%s], use USER@DOMAIN instead.", (Object[])new Object[]{this.cifsConnectionType.toString().toLowerCase(), this.username});
        this.options = options;
    }

    @Override
    public OverthereProcess startProcess(CmdLine commandLine) {
        final String obfuscatedCommandLine = commandLine.toCommandLine(this.getHostOperatingSystem(), true);
        String cmd = commandLine.toCommandLine(this.getHostOperatingSystem(), false);
        if (this.workingDirectory != null) {
            cmd = "CD /D " + this.workingDirectory.getPath() + " & " + cmd;
        }
        final WinRmClient winRmClient = this.createWinrmClient();
        try {
            final PipedInputStream toCallersStdin = new PipedInputStream();
            final PipedOutputStream callersStdin = new PipedOutputStream(toCallersStdin);
            final PipedInputStream callersStdout = new PipedInputStream();
            final PipedOutputStream toCallersStdout = new PipedOutputStream(callersStdout);
            final PipedInputStream callersStderr = new PipedInputStream();
            final PipedOutputStream toCallersStderr = new PipedOutputStream(callersStderr);
            winRmClient.createShell();
            winRmClient.executeCommand(cmd);
            final Exception[] processInputReaderTheaException = new Exception[1];
            Thread processInputReaderThead = new Thread(String.format("Input reader for [%s] on [%s]", obfuscatedCommandLine, this)){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        int n;
                        byte[] buf = new byte[4096];
                        while ((n = toCallersStdin.read(buf)) != -1) {
                            if (n == 0) continue;
                            byte[] bufToSend = new byte[n];
                            System.arraycopy(buf, 0, bufToSend, 0, n);
                            winRmClient.sendInput(bufToSend);
                        }
                    }
                    catch (Exception exc) {
                        processInputReaderTheaException[0] = exc;
                    }
                    finally {
                        Closeables.closeQuietly((Closeable)callersStdin);
                    }
                }
            };
            processInputReaderThead.setDaemon(true);
            processInputReaderThead.start();
            final Exception[] processOutputReaderThreadException = new Exception[1];
            final Thread processOutputReaderThread = new Thread(String.format("Output reader for [%s] on [%s]", obfuscatedCommandLine, this)){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        while (winRmClient.receiveOutput(toCallersStdout, toCallersStderr)) {
                        }
                    }
                    catch (Exception exc) {
                        processOutputReaderThreadException[0] = exc;
                    }
                    finally {
                        Closeables.closeQuietly((Closeable)toCallersStdout);
                        Closeables.closeQuietly((Closeable)toCallersStderr);
                    }
                }
            };
            processOutputReaderThread.start();
            return new OverthereProcess(){
                boolean processTerminated = false;

                @Override
                public synchronized OutputStream getStdin() {
                    return callersStdin;
                }

                @Override
                public synchronized InputStream getStdout() {
                    return callersStdout;
                }

                @Override
                public synchronized InputStream getStderr() {
                    return callersStderr;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public synchronized int waitFor() {
                    if (this.processTerminated) {
                        return this.exitValue();
                    }
                    try {
                        try {
                            processOutputReaderThread.join();
                        }
                        finally {
                            winRmClient.deleteShell();
                            this.processTerminated = true;
                        }
                        if (processOutputReaderThreadException[0] != null) {
                            if (processOutputReaderThreadException[0] instanceof RuntimeException) {
                                throw (RuntimeException)processOutputReaderThreadException[0];
                            }
                            throw new RuntimeIOException(String.format("Cannot execute command [%s] on [%s]", obfuscatedCommandLine, CifsWinRmConnection.this), processOutputReaderThreadException[0]);
                        }
                        return this.exitValue();
                    }
                    catch (InterruptedException exc) {
                        throw new RuntimeIOException(String.format("Cannot execute command [%s] on [%s]", obfuscatedCommandLine, CifsWinRmConnection.this), exc);
                    }
                }

                @Override
                public synchronized void destroy() {
                    if (this.processTerminated) {
                        return;
                    }
                    winRmClient.signal();
                    winRmClient.deleteShell();
                    this.processTerminated = true;
                }

                @Override
                public synchronized int exitValue() {
                    if (!this.processTerminated) {
                        throw new IllegalThreadStateException(String.format("Process for command [%s] on [%s] is still running", obfuscatedCommandLine, CifsWinRmConnection.this));
                    }
                    return winRmClient.exitValue();
                }
            };
        }
        catch (IOException exc) {
            throw new RuntimeIOException("Cannot execute command " + commandLine + " on " + this, exc);
        }
    }

    private WinRmClient createWinrmClient() {
        WinRmClient client = new WinRmClient(this.username, this.password, this.createTargetURL(this.options), this.unmappedAddress, this.unmappedPort);
        client.setWinRmTimeout(this.options.get("winrmTimeout", "PT60.000S"));
        client.setWinRmEnvelopSize(this.options.get("winrmEnvelopSize", 153600));
        client.setWinRmLocale(this.options.get("winrmLocale", "en-US"));
        client.setHttpsCertTrustStrategy(this.options.getEnum("winrmHttpsCertificateTrustStrategy", WinrmHttpsCertificateTrustStrategy.class, CifsConnectionBuilder.DEFAULT_WINRM_HTTPS_CERTIFICATE_TRUST_STRATEGY));
        client.setHttpsHostnameVerifyStrategy(this.options.getEnum("winrmHttpsHostnameVerificationStrategy", WinrmHttpsHostnameVerificationStrategy.class, CifsConnectionBuilder.DEFAULT_WINRM_HTTPS_HOSTNAME_VERIFICATION_STRATEGY));
        client.setKerberosUseHttpSpn(this.options.getBoolean("winrmKerberosUseHttpSpn", false));
        client.setKerberosAddPortToSpn(this.options.getBoolean("winrmKerberosAddPortToSpn", false));
        client.setKerberosDebug(this.options.getBoolean("winrmKerberosDebug", false));
        return client;
    }

    private URL createTargetURL(ConnectionOptions options) {
        String scheme = options.getBoolean("winrmEnableHttps", false) ? "https" : "http";
        String context = options.get("winrmContext", "/wsman");
        try {
            return new URL(scheme, this.address, this.port, context);
        }
        catch (MalformedURLException e) {
            throw new WinRmRuntimeIOException("Cannot build a new URL for " + this, e);
        }
    }
}

