/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.overthere.ssh;

import com.google.common.annotations.VisibleForTesting;
import com.xebialabs.overthere.CmdLine;
import com.xebialabs.overthere.CmdLineArgument;
import com.xebialabs.overthere.ConnectionOptions;
import com.xebialabs.overthere.OverthereFile;
import com.xebialabs.overthere.RuntimeIOException;
import com.xebialabs.overthere.spi.AddressPortMapper;
import com.xebialabs.overthere.ssh.SshScpConnection;
import com.xebialabs.overthere.ssh.SshSudoFile;
import com.xebialabs.overthere.util.OverthereUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SshSudoConnection
extends SshScpConnection {
    public static final String NOSUDO_PSEUDO_COMMAND = "nosudo";
    protected final String sudoUsername;
    protected final String sudoCommandPrefix;
    protected final boolean sudoQuoteCommand;
    protected final boolean sudoPreserveAttributesOnCopyFromTempFile;
    protected final boolean sudoPreserveAttributesOnCopyToTempFile;
    protected final boolean sudoOverrideUmask;
    private Logger logger = LoggerFactory.getLogger(SshSudoFile.class);

    public SshSudoConnection(String type, ConnectionOptions options, AddressPortMapper mapper) {
        super(type, options, mapper);
        this.sudoUsername = (String)options.get("sudoUsername");
        this.sudoCommandPrefix = options.get("sudoCommandPrefix", "sudo -u {0}");
        this.sudoQuoteCommand = options.getBoolean("sudoQuoteCommand", false);
        this.sudoPreserveAttributesOnCopyFromTempFile = options.getBoolean("sudoPreserveAttributesOnCopyFromTempFile", true);
        this.sudoPreserveAttributesOnCopyToTempFile = options.getBoolean("sudoPreserveAttributesOnCopyToTempFile", true);
        this.sudoOverrideUmask = options.get("sudoOverrideUmask", true);
    }

    @Override
    protected CmdLine processCommandLine(CmdLine commandLine) {
        CmdLine cmd;
        if (this.startsWithPseudoCommand(commandLine, NOSUDO_PSEUDO_COMMAND)) {
            this.logger.trace("Not prefixing command line with sudo statement because the nosudo pseudo command was present, but the pseudo command will be stripped");
            this.logger.trace("Replacing: {}", (Object)commandLine);
            cmd = SshSudoConnection.stripPrefixedPseudoCommand(commandLine);
            this.logger.trace("With     : {}", (Object)cmd);
        } else {
            this.logger.trace("Prefixing command line with sudo statement");
            this.logger.trace("Replacing: {}", (Object)commandLine);
            boolean nocd = this.startsWithPseudoCommand(commandLine, "nocd");
            cmd = nocd ? SshSudoConnection.stripPrefixedPseudoCommand(commandLine) : commandLine;
            cmd = this.prefixWithSudoCommand(cmd);
            if (nocd) {
                cmd = SshSudoConnection.prefixWithPseudoCommand(cmd, "nocd");
            }
            this.logger.trace("With     : {}", (Object)cmd);
        }
        return super.processCommandLine(cmd);
    }

    @VisibleForTesting
    CmdLine prefixWithSudoCommand(CmdLine commandLine) {
        CmdLine commandLineWithSudo = new CmdLine();
        commandLineWithSudo.addTemplatedFragment(this.sudoCommandPrefix, this.sudoUsername);
        if (this.sudoQuoteCommand) {
            commandLineWithSudo.addNested(commandLine);
        } else {
            for (CmdLineArgument a : commandLine.getArguments()) {
                commandLineWithSudo.add(a);
                if (!a.toString(this.os, false).equals("|") && !a.toString(this.os, false).equals(";")) continue;
                commandLineWithSudo.addTemplatedFragment(this.sudoCommandPrefix, this.sudoUsername);
            }
        }
        return commandLineWithSudo;
    }

    @Override
    public OverthereFile getFile(String hostPath) throws RuntimeIOException {
        return new SshSudoFile(this, hostPath, false);
    }

    @Override
    public OverthereFile getFile(OverthereFile parent, String child) throws RuntimeIOException {
        this.checkParentFile(parent);
        return new SshSudoFile(this, OverthereUtils.constructPath(parent, child), ((SshSudoFile)parent).isTempFile());
    }

    @Override
    protected OverthereFile getFileForTempFile(OverthereFile parent, String name) {
        this.checkParentFile(parent);
        return new SshSudoFile(this, OverthereUtils.constructPath(parent, name), true);
    }

    @Override
    public String toString() {
        return "ssh:" + this.sshConnectionType.toString().toLowerCase() + "://" + this.username + ":" + this.sudoUsername + "@" + this.host + ":" + this.port;
    }
}

