/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.changes;

import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveInputStream;
import org.apache.commons.compress.archivers.ArchiveOutputStream;
import org.apache.commons.compress.changes.Change;
import org.apache.commons.compress.changes.ChangeSet;
import org.apache.commons.compress.changes.ChangeSetResults;
import org.apache.commons.compress.utils.IOUtils;

public class ChangeSetPerformer {
    private final Set changes;

    public ChangeSetPerformer(ChangeSet changeSet) {
        this.changes = changeSet.getChanges();
    }

    public ChangeSetResults perform(ArchiveInputStream in, ArchiveOutputStream out) throws IOException {
        ChangeSetResults results = new ChangeSetResults();
        LinkedHashSet workingSet = new LinkedHashSet(this.changes);
        Iterator it = workingSet.iterator();
        while (it.hasNext()) {
            Change change = (Change)it.next();
            if (change.type() != 2 || !change.isReplaceMode()) continue;
            this.copyStream(change.getInput(), out, change.getEntry());
            it.remove();
            results.addedFromChangeSet(change.getEntry().getName());
        }
        ArchiveEntry entry = null;
        while ((entry = in.getNextEntry()) != null) {
            boolean copy = true;
            Iterator it2 = workingSet.iterator();
            while (it2.hasNext()) {
                Change change = (Change)it2.next();
                int type = change.type();
                String name = entry.getName();
                if (type == 1 && name != null) {
                    if (!name.equals(change.targetFile())) continue;
                    copy = false;
                    it2.remove();
                    results.deleted(name);
                    break;
                }
                if (type != 4 || name == null || !name.startsWith(change.targetFile() + "/")) continue;
                copy = false;
                results.deleted(name);
                break;
            }
            if (!copy || this.isDeletedLater(workingSet, entry) || results.hasBeenAdded(entry.getName())) continue;
            this.copyStream(in, out, entry);
            results.addedFromStream(entry.getName());
        }
        Iterator it3 = workingSet.iterator();
        while (it3.hasNext()) {
            Change change = (Change)it3.next();
            if (change.type() != 2 || change.isReplaceMode() || results.hasBeenAdded(change.getEntry().getName())) continue;
            this.copyStream(change.getInput(), out, change.getEntry());
            it3.remove();
            results.addedFromChangeSet(change.getEntry().getName());
        }
        out.finish();
        return results;
    }

    private boolean isDeletedLater(Set workingSet, ArchiveEntry entry) {
        String source = entry.getName();
        if (!workingSet.isEmpty()) {
            Iterator it = workingSet.iterator();
            while (it.hasNext()) {
                Change change = (Change)it.next();
                int type = change.type();
                String target = change.targetFile();
                if (type == 1 && source.equals(target)) {
                    return true;
                }
                if (type != 4 || !source.startsWith(target + "/")) continue;
                return true;
            }
        }
        return false;
    }

    private void copyStream(InputStream in, ArchiveOutputStream out, ArchiveEntry entry) throws IOException {
        out.putArchiveEntry(entry);
        IOUtils.copy(in, out);
        out.closeArchiveEntry();
    }
}

