/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.plugins.providers.jaxb;

import java.lang.annotation.Annotation;
import java.util.concurrent.ConcurrentHashMap;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.ext.ContextResolver;
import javax.ws.rs.ext.Provider;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import org.jboss.resteasy.annotations.providers.jaxb.JAXBConfig;
import org.jboss.resteasy.plugins.providers.jaxb.AbstractJAXBContextFinder;
import org.jboss.resteasy.plugins.providers.jaxb.JAXBContextFinder;
import org.jboss.resteasy.plugins.providers.jaxb.JAXBContextWrapper;
import org.jboss.resteasy.util.FindAnnotation;

@Provider
@Produces(value={"text/*+xml", "application/*+xml"})
public class XmlJAXBContextFinder
extends AbstractJAXBContextFinder
implements ContextResolver<JAXBContextFinder> {
    private ConcurrentHashMap<Class<?>, JAXBContext> cache = new ConcurrentHashMap();
    private ConcurrentHashMap<AbstractJAXBContextFinder.CacheKey, JAXBContext> collectionCache = new ConcurrentHashMap();
    private ConcurrentHashMap<AbstractJAXBContextFinder.CacheKey, JAXBContext> xmlTypeCollectionCache = new ConcurrentHashMap();

    @Override
    public JAXBContext findCachedContext(Class type, MediaType mediaType, Annotation[] parameterAnnotations) throws JAXBException {
        JAXBContext jaxb = this.cache.get(type);
        if (jaxb != null) {
            return jaxb;
        }
        jaxb = this.findProvidedJAXBContext(type, mediaType);
        if (jaxb != null) {
            this.cache.putIfAbsent(type, jaxb);
            return jaxb;
        }
        jaxb = this.createContext(parameterAnnotations, type);
        if (jaxb != null) {
            this.cache.putIfAbsent(type, jaxb);
        }
        JAXBContext result = jaxb;
        return result;
    }

    @Override
    protected JAXBContext createContextObject(Annotation[] parameterAnnotations, Class ... classes) throws JAXBException {
        JAXBConfig config = (JAXBConfig)FindAnnotation.findAnnotation((Annotation[])parameterAnnotations, JAXBConfig.class);
        return new JAXBContextWrapper(config, classes);
    }

    @Override
    protected JAXBContext createContextObject(Annotation[] parameterAnnotations, String contextPath) throws JAXBException {
        JAXBConfig config = (JAXBConfig)FindAnnotation.findAnnotation((Annotation[])parameterAnnotations, JAXBConfig.class);
        return new JAXBContextWrapper(contextPath, config);
    }

    @Override
    public JAXBContext findCacheContext(MediaType mediaType, Annotation[] paraAnnotations, Class ... classes) throws JAXBException {
        AbstractJAXBContextFinder.CacheKey key = new AbstractJAXBContextFinder.CacheKey(classes);
        JAXBContext ctx = this.collectionCache.get(key);
        if (ctx != null) {
            return ctx;
        }
        ctx = this.createContext(paraAnnotations, classes);
        this.collectionCache.put(key, ctx);
        return ctx;
    }

    @Override
    public JAXBContext findCacheXmlTypeContext(MediaType mediaType, Annotation[] paraAnnotations, Class ... classes) throws JAXBException {
        AbstractJAXBContextFinder.CacheKey key = new AbstractJAXBContextFinder.CacheKey(classes);
        JAXBContext ctx = this.xmlTypeCollectionCache.get(key);
        if (ctx != null) {
            return ctx;
        }
        ctx = this.createXmlTypeContext(paraAnnotations, classes);
        this.xmlTypeCollectionCache.put(key, ctx);
        return ctx;
    }
}

