/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.rest.api;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.io.Files;
import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.core.api.InternalReportProxy;
import com.xebialabs.deployit.core.api.dto.Report;
import com.xebialabs.deployit.core.api.resteasy.Date;
import com.xebialabs.deployit.core.rest.api.DownloadResource;
import com.xebialabs.deployit.core.rest.api.reports.AggregatedDeploymentsKeyIndicator;
import com.xebialabs.deployit.core.rest.api.reports.DeploymentsForEnvironmentReport;
import com.xebialabs.deployit.core.rest.api.reports.DeploymentsKeyIndicator;
import com.xebialabs.deployit.core.rest.api.reports.DeploymentsStateBreakdownReport;
import com.xebialabs.deployit.core.rest.api.reports.ProvisioningReport;
import com.xebialabs.deployit.core.rest.api.reports.ReportUtils;
import com.xebialabs.deployit.core.rest.api.reports.TaskReport;
import com.xebialabs.deployit.core.rest.api.reports.widgets.WidgetRegistry;
import com.xebialabs.deployit.core.rest.resteasy.WorkDirTemplate;
import com.xebialabs.deployit.core.rest.resteasy.Workdir;
import com.xebialabs.deployit.core.rest.resteasy.WorkdirHolder;
import com.xebialabs.deployit.engine.api.dto.ConfigurationItemId;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.repository.WorkDir;
import com.xebialabs.deployit.task.FilterType;
import com.xebialabs.deployit.task.archive.JcrTaskArchive;
import java.io.File;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.List;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;

@Controller
public class ReportResource
implements InternalReportProxy {
    @Autowired
    private JcrTaskArchive taskArchive;
    @Autowired
    private DownloadResource downloadResource;
    private static final DateTimeFormatter DATE_FORMAT = DateTimeFormat.forPattern((String)"yyyyMMdd");

    public Report deploymentsForEnvironment(String environment, Date date, String acceptedContentType) {
        Checks.checkNotNull((Object)environment, (String)"environment");
        Checks.checkNotNull((Object)date, (String)"date");
        Checks.checkNotNull((Object)date.getCalendar(), (String)"date");
        DeploymentsForEnvironmentReport report = new DeploymentsForEnvironmentReport(this.taskArchive);
        report.getSearchParameters().forEnvironment(environment).createdOnOrBefore(date.asDateTime());
        return report.report();
    }

    @Workdir
    public String downloadDeploymentsForEnvironment(final String environment, final Date date, final @HeaderParam(value="Accept") String acceptedContentType) {
        return (String)WorkDirTemplate.cleanOnException((WorkDirTemplate.Callback)new WorkDirTemplate.Callback<String>(){

            public String doWithWorkdir(WorkDir workDir) {
                Report report = ReportResource.this.deploymentsForEnvironment(environment, date, acceptedContentType);
                String fileName = String.format("deployments-%s-%s.csv", environment.replaceAll("/", "_"), DATE_FORMAT.print((ReadableInstant)date.asDateTime()));
                return ReportResource.this.createDownloadToken(report, fileName);
            }
        });
    }

    public Report getTaskReport(Date begin, Date end, String acceptedContentType, String filterType, List<ConfigurationItemId> configurationItemIds) {
        FilterType filter;
        Checks.checkNotNull((Object)begin, (String)"begin");
        Checks.checkNotNull((Object)end, (String)"end");
        TaskReport report = new TaskReport(this.taskArchive);
        report.getSearchParameters().createdBetween(begin.asDateTime(), end.asDateTime());
        if (filterType != null && (filter = FilterType.valueOf((String)filterType.toUpperCase())) != FilterType.NONE) {
            report.getSearchParameters().forFilterType(filter, configurationItemIds);
        }
        return report.report();
    }

    @Workdir
    public String downloadTaskReport(final Date begin, final Date end, final String acceptedContentType, final String filterType, final List<ConfigurationItemId> configurationItemIds) {
        return (String)WorkDirTemplate.cleanOnException((WorkDirTemplate.Callback)new WorkDirTemplate.Callback<String>(){

            public String doWithWorkdir(WorkDir workDir) {
                Report report = ReportResource.this.getTaskReport(begin, end, acceptedContentType, filterType, configurationItemIds);
                String fileName = String.format("tasks-%s-%s.csv", DATE_FORMAT.print((ReadableInstant)begin.asDateTime()), DATE_FORMAT.print((ReadableInstant)end.asDateTime()));
                return ReportResource.this.createDownloadToken(report, fileName);
            }
        });
    }

    public Report getCloudTasksReport(Date begin, Date end, String acceptedContentType, String filterType, List<ConfigurationItemId> configurationItemIds) {
        FilterType filter;
        Checks.checkNotNull((Object)begin, (String)"begin");
        Checks.checkNotNull((Object)end, (String)"end");
        ProvisioningReport report = new ProvisioningReport(this.taskArchive);
        report.getSearchParameters().createdBetween(begin.asDateTime(), end.asDateTime());
        FilterType filterType2 = filter = filterType == null ? FilterType.NONE : FilterType.valueOf((String)filterType.toUpperCase());
        if (filter == FilterType.NONE) {
            report.getSearchParameters().forAllCloudEnvironmentTemplates();
        } else {
            report.getSearchParameters().forFilterType(filter, configurationItemIds);
        }
        return report.report();
    }

    @Workdir
    public String downloadCloudTasksReport(final Date begin, final Date end, final String acceptedContentType, final String filterType, final List<ConfigurationItemId> configurationItemIds) {
        return (String)WorkDirTemplate.cleanOnException((WorkDirTemplate.Callback)new WorkDirTemplate.Callback<String>(){

            public String doWithWorkdir(WorkDir workDir) {
                Report report = ReportResource.this.getCloudTasksReport(begin, end, acceptedContentType, filterType, configurationItemIds);
                String fileName = String.format("tasks-%s-%s.csv", DATE_FORMAT.print((ReadableInstant)begin.asDateTime()), DATE_FORMAT.print((ReadableInstant)end.asDateTime()));
                return ReportResource.this.createDownloadToken(report, fileName);
            }
        });
    }

    @GET
    @Path(value="cloudenvironmenttemplates")
    @Produces(value={"application/xml"})
    public List<ConfigurationItemId> listCloudEnvironmentTemplates() {
        List templateList = this.taskArchive.getCloudEnvironmentTemplates();
        Collections.sort(templateList);
        return Lists.newArrayList((Iterable)Lists.transform((List)templateList, ReportResource.toConfigurationItemId("cloud.EnvironmentTemplate")));
    }

    public Report deploymentsStateBreakdown(String filterType, Date begin, Date end, String acceptedContentType, List<ConfigurationItemId> configurationItemIds) {
        Checks.checkNotNull((Object)filterType, (String)"filterType");
        Checks.checkNotNull((Object)begin, (String)"begin");
        Checks.checkNotNull((Object)begin.getCalendar(), (String)"begin");
        Checks.checkNotNull((Object)end, (String)"end");
        Checks.checkNotNull((Object)end.getCalendar(), (String)"end");
        Checks.checkNotNull(configurationItemIds, (String)"configurationItemIds");
        DeploymentsStateBreakdownReport report = new DeploymentsStateBreakdownReport(this.taskArchive);
        report.getSearchParameters().createdBetween(begin.asDateTime(), end.asDateTime());
        FilterType reportFilterType = FilterType.valueOf((String)filterType.toUpperCase());
        return report.report(reportFilterType, configurationItemIds);
    }

    @Workdir
    public String downloadDeploymentsStateBreakdown(final String filterType, final Date begin, final Date end, final @HeaderParam(value="Accept") String acceptedContentType, final List<ConfigurationItemId> configurationItemIds) {
        return (String)WorkDirTemplate.cleanOnException((WorkDirTemplate.Callback)new WorkDirTemplate.Callback<String>(){

            public String doWithWorkdir(WorkDir workDir) {
                Report report = ReportResource.this.deploymentsStateBreakdown(filterType, begin, end, acceptedContentType, configurationItemIds);
                String fileName = String.format("deployments-by-state-%s-%s.csv", DATE_FORMAT.print((ReadableInstant)begin.asDateTime()), DATE_FORMAT.print((ReadableInstant)end.asDateTime()));
                return ReportResource.this.createDownloadToken(report, fileName);
            }
        });
    }

    public Report deploymentsKeyIndicator(Date begin, Date end, String acceptedContentType, String filterType, List<ConfigurationItemId> configurationItemIds) {
        FilterType filter;
        Checks.checkNotNull((Object)begin, (String)"begin");
        Checks.checkNotNull((Object)begin.getCalendar(), (String)"begin");
        Checks.checkNotNull((Object)end, (String)"end");
        Checks.checkNotNull((Object)end.getCalendar(), (String)"end");
        DeploymentsKeyIndicator report = new DeploymentsKeyIndicator(this.taskArchive);
        report.getSearchParameters().createdBetween(begin.asDateTime(), end.asDateTime());
        if (filterType != null && (filter = FilterType.valueOf((String)filterType.toUpperCase())) != FilterType.NONE) {
            report.getSearchParameters().forFilterType(filter, configurationItemIds);
        }
        return report.report();
    }

    public Report deploymentsKeyIndicatorAggregatedByFilterType(String filterType, Date begin, Date end, String acceptedContentType, List<ConfigurationItemId> configurationItemIds) {
        Checks.checkNotNull((Object)filterType, (String)"filterType");
        Checks.checkNotNull((Object)begin, (String)"begin");
        Checks.checkNotNull((Object)begin.getCalendar(), (String)"begin");
        Checks.checkNotNull((Object)end, (String)"end");
        Checks.checkNotNull((Object)end.getCalendar(), (String)"end");
        Checks.checkNotNull(configurationItemIds, (String)"configurationItemIds");
        FilterType reportFilterType = FilterType.valueOf((String)filterType.toUpperCase());
        AggregatedDeploymentsKeyIndicator report = new AggregatedDeploymentsKeyIndicator(this.taskArchive);
        report.getSearchParameters().createdBetween(new DateTime((Object)begin.getCalendar()), new DateTime((Object)end.getCalendar()));
        return report.report(reportFilterType, configurationItemIds);
    }

    @Workdir
    public String downloadDeploymentsKeyIndicator(final String filterType, final Date begin, final Date end, final String acceptedContentType, final List<ConfigurationItemId> cis) {
        return (String)WorkDirTemplate.cleanOnException((WorkDirTemplate.Callback)new WorkDirTemplate.Callback<String>(){

            public String doWithWorkdir(WorkDir workDir) {
                Report report = ReportResource.this.deploymentsKeyIndicator(begin, end, acceptedContentType, filterType, cis);
                String fileName = String.format("deployments-key-indicator-%s-%s.csv", DATE_FORMAT.print((ReadableInstant)begin.asDateTime()), DATE_FORMAT.print((ReadableInstant)end.asDateTime()));
                return ReportResource.this.createDownloadToken(report, fileName);
            }
        });
    }

    @Workdir
    public String downloadDeploymentsKeyIndicatorAggregatedByFilterType(final String filterType, final Date begin, final Date end, final @HeaderParam(value="Accept") String acceptedContentType, final List<ConfigurationItemId> configurationItemIds) {
        return (String)WorkDirTemplate.cleanOnException((WorkDirTemplate.Callback)new WorkDirTemplate.Callback<String>(){

            public String doWithWorkdir(WorkDir workDir) {
                Report report = ReportResource.this.deploymentsKeyIndicatorAggregatedByFilterType(filterType, begin, end, acceptedContentType, configurationItemIds);
                String fileName = String.format("aggregated-deployments-key-indicator-%s-%s-%s.csv", filterType, DATE_FORMAT.print((ReadableInstant)begin.asDateTime()), DATE_FORMAT.print((ReadableInstant)end.asDateTime()));
                return ReportResource.this.createDownloadToken(report, fileName);
            }
        });
    }

    public Response getDashboardWidgetReport(String widget, Date begin, Date end) {
        Checks.checkNotNull((Object)widget, (String)"widget");
        Checks.checkNotNull((Object)begin, (String)"begin");
        Checks.checkNotNull((Object)begin.getCalendar(), (String)"begin");
        Checks.checkNotNull((Object)end, (String)"end");
        Checks.checkNotNull((Object)end.getCalendar(), (String)"end");
        Preconditions.checkArgument((begin.getCalendar().getTime().compareTo(end.getCalendar().getTime()) <= 0 ? 1 : 0) != 0);
        return Response.ok((Object)WidgetRegistry.valueOf(WidgetRegistry.class, widget.toUpperCase()).getWidget(this.taskArchive).getReport(begin.asDateTime(), end.asDateTime())).build();
    }

    public List<ConfigurationItemId> listEnvironments() {
        List environments = this.taskArchive.getAllEnvironments();
        Collections.sort(environments);
        return Lists.newArrayList((Iterable)Lists.transform((List)environments, ReportResource.toConfigurationItemId("udm.Environment")));
    }

    private static Function<String, ConfigurationItemId> toConfigurationItemId(final String type) {
        return new Function<String, ConfigurationItemId>(){

            public ConfigurationItemId apply(String input) {
                return new ConfigurationItemId(input, Type.valueOf((String)type));
            }
        };
    }

    private String createDownloadToken(Report report, String fileName) {
        try {
            File to = new File(WorkdirHolder.get().getPath(), fileName);
            Files.write((CharSequence)ReportUtils.toCsv(report), (File)to, (Charset)Charset.defaultCharset());
            return this.downloadResource.register(to, WorkdirHolder.get(), "text/csv");
        }
        catch (Exception re) {
            LoggerFactory.getLogger(this.getClass()).error("Oops!", (Throwable)re);
            WorkdirHolder.get().delete();
            throw new IllegalStateException(re);
        }
    }
}

