/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.api.JackrabbitRepository;
import org.apache.jackrabbit.api.JackrabbitRepositoryFactory;
import org.apache.jackrabbit.api.management.RepositoryManager;
import org.apache.jackrabbit.core.RepositoryManagerImpl;
import org.apache.jackrabbit.core.TransientRepository;

public class RepositoryFactoryImpl
implements JackrabbitRepositoryFactory {
    public static final String REPOSITORY_HOME = "org.apache.jackrabbit.repository.home";
    public static final String REPOSITORY_CONF = "org.apache.jackrabbit.repository.conf";
    private static final Map<Properties, TransientRepository> REPOSITORIES = new HashMap<Properties, TransientRepository>();
    private final Set<TransientRepository> ownRepositories = new HashSet<TransientRepository>();

    public Repository getRepository(Map parameters) throws RepositoryException {
        if (parameters == null) {
            return this.getRepository(null, Collections.emptyMap());
        }
        if (parameters.containsKey(REPOSITORY_HOME)) {
            String home = parameters.get(REPOSITORY_HOME).toString();
            return this.getRepository(home, parameters);
        }
        if (parameters.containsKey("org.apache.jackrabbit.repository.uri")) {
            Object parameter = parameters.get("org.apache.jackrabbit.repository.uri");
            try {
                URI uri = new URI(parameter.toString().trim());
                String scheme = uri.getScheme();
                if (("file".equalsIgnoreCase(scheme) || "jcr-jackrabbit".equalsIgnoreCase(scheme)) && uri.getAuthority() == null) {
                    File file = new File(uri.getPath());
                    if (file.isFile()) {
                        return null;
                    }
                    return this.getRepository(file.getPath(), parameters);
                }
                return null;
            }
            catch (URISyntaxException e) {
                return null;
            }
        }
        return null;
    }

    private Repository getRepository(String home, Map<?, ?> parameters) throws RepositoryException {
        TransientRepository repository = RepositoryFactoryImpl.getOrCreateRepository(home, parameters);
        this.ownRepositories.add(repository);
        return repository;
    }

    private static synchronized TransientRepository getOrCreateRepository(String home, Map<?, ?> parameters) throws RepositoryException {
        TransientRepository repository;
        Properties properties = new Properties(System.getProperties());
        for (Map.Entry<?, ?> entry : parameters.entrySet()) {
            Object key = entry.getKey();
            if (key == null) continue;
            Object value = entry.getValue();
            if (value != null) {
                properties.setProperty(key.toString(), value.toString());
                continue;
            }
            properties.remove(key.toString());
        }
        if (home != null) {
            properties.put("rep.home", home);
        }
        if ((repository = REPOSITORIES.get(properties)) == null) {
            try {
                TransientRepository tr;
                if (home == null) {
                    tr = new TransientRepository(properties);
                    REPOSITORIES.put(null, tr);
                } else {
                    tr = new TransientRepository(properties);
                }
                REPOSITORIES.put(properties, tr);
                repository = tr;
            }
            catch (IOException e) {
                throw new RepositoryException("Failed to install repository configuration", (Throwable)e);
            }
        }
        return repository;
    }

    public RepositoryManager getRepositoryManager(JackrabbitRepository repo) throws RepositoryException {
        if (!(repo instanceof TransientRepository)) {
            throw new RepositoryException("The repository was not created in this factory");
        }
        if (!this.ownRepositories.contains(repo)) {
            throw new RepositoryException("The repository was not created in this factory");
        }
        return new RepositoryManagerImpl((TransientRepository)repo);
    }
}

