/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.service.importer.source;

import com.google.common.io.ByteStreams;
import com.google.common.io.Closeables;
import com.google.common.io.Files;
import com.google.common.io.OutputSupplier;
import com.xebialabs.deployit.exception.RuntimeIOException;
import com.xebialabs.deployit.server.api.importer.ImportSource;
import com.xebialabs.deployit.service.importer.source.FileSource;
import com.xebialabs.deployit.util.GuavaFiles;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HeaderElement;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.methods.GetMethod;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UrlSource
implements ImportSource {
    private static final String CONTENT_DISPOSITION = "Content-disposition";
    private static final String ATTACHMENT = "attachment";
    private final URL location;
    private FileSource downloaded;
    private File tempDir;
    private static final Logger logger = LoggerFactory.getLogger(UrlSource.class);

    public UrlSource(URL location) {
        this.location = location;
    }

    private void download() {
        try {
            logger.debug("Preparing to download package from {}", (Object)this.location);
            HttpClient client = new HttpClient();
            URI uri = this.location.toURI();
            GetMethod method = new GetMethod(uri.toString());
            int statusCode = client.executeMethod((HttpMethod)method);
            if (statusCode != 200) {
                throw new RuntimeIOException("Failed to download package,status=" + statusCode + ", from url " + this.location);
            }
            String filename = UrlSource.getFilenameFromResponse((HttpMethod)method);
            logger.trace("File name from response: {}", (Object)filename);
            if (filename == null) {
                String path = uri.getPath();
                logger.debug("Getting target file name from path {}", (Object)path);
                filename = new File(path).getName();
            }
            this.save(filename, method.getResponseBodyAsStream());
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Invalid URL", e);
        }
        catch (HttpException e) {
            throw new RuntimeIOException((Throwable)e);
        }
        catch (IOException e) {
            throw new RuntimeIOException((Throwable)e);
        }
    }

    private static String getFilenameFromResponse(HttpMethod method) {
        Header contentDisposition = method.getResponseHeader(CONTENT_DISPOSITION);
        if (contentDisposition == null) {
            return null;
        }
        for (HeaderElement element : contentDisposition.getElements()) {
            if (!element.getName().equalsIgnoreCase(ATTACHMENT)) continue;
            NameValuePair filenameParam = element.getParameterByName("filename");
            return filenameParam != null ? filenameParam.getValue() : null;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void save(String name, InputStream responseBodyAsStream) throws IOException {
        try {
            this.tempDir = Files.createTempDir();
            File archive = new File(this.tempDir, name);
            ByteStreams.copy((InputStream)responseBodyAsStream, (OutputSupplier)Files.newOutputStreamSupplier((File)archive));
            this.downloaded = new FileSource(archive, true);
        }
        finally {
            Closeables.closeQuietly((Closeable)responseBodyAsStream);
        }
    }

    public File getFile() {
        if (this.downloaded == null) {
            this.download();
            logger.debug("Successfully downloaded file {}", (Object)this.downloaded.getFile().getName());
        }
        return this.downloaded.getFile();
    }

    public void cleanUp() {
        if (this.downloaded != null) {
            this.downloaded.cleanUp();
        }
        if (this.tempDir != null) {
            GuavaFiles.deleteQuietly((File)this.tempDir);
        }
    }

    public String toString() {
        return "UrlSource[" + this.location + "]";
    }
}

