/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.trigger;

import com.google.common.collect.Sets;
import com.xebialabs.deployit.engine.api.execution.TaskExecutionState;
import com.xebialabs.deployit.plugin.trigger.TriggerState;
import java.util.Set;

public enum TaskState implements TriggerState<TaskExecutionState>
{
    ANY(null, null),
    QUEUED(TaskExecutionState.QUEUED, Sets.newHashSet((Object[])new TaskExecutionState[]{TaskExecutionState.EXECUTING})),
    PENDING(TaskExecutionState.PENDING, Sets.newHashSet((Object[])new TaskExecutionState[]{TaskExecutionState.EXECUTING, TaskExecutionState.QUEUED})),
    EXECUTING(TaskExecutionState.EXECUTING, Sets.newHashSet((Object[])new TaskExecutionState[]{TaskExecutionState.STOPPED, TaskExecutionState.EXECUTED})),
    DONE(TaskExecutionState.DONE, Sets.newHashSet()),
    STOPPED(TaskExecutionState.STOPPED, Sets.newHashSet((Object[])new TaskExecutionState[]{TaskExecutionState.EXECUTING, TaskExecutionState.CANCELLED})),
    EXECUTED(TaskExecutionState.EXECUTED, Sets.newHashSet((Object[])new TaskExecutionState[]{TaskExecutionState.DONE})),
    CANCELLED(TaskExecutionState.CANCELLED, Sets.newHashSet());

    private TaskExecutionState taskExecutionState;
    private Set<TaskExecutionState> validToTransition;

    private TaskState(TaskExecutionState taskExecutionState, Set<TaskExecutionState> validToTransition) {
        this.taskExecutionState = taskExecutionState;
        this.validToTransition = validToTransition;
    }

    @Override
    public boolean equivalentTo(TaskExecutionState spiState) {
        if (spiState == null) {
            return false;
        }
        return this.taskExecutionState == null || this.taskExecutionState == spiState;
    }

    public boolean isValidTransition(TaskState toState) {
        if (this.taskExecutionState == null || toState.taskExecutionState == null) {
            return true;
        }
        return this.validToTransition.contains(toState.taskExecutionState);
    }
}

