/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.overthere.cifs.winrm;

import com.google.common.base.Preconditions;
import com.google.common.io.Closeables;
import com.xebialabs.overthere.CmdLine;
import com.xebialabs.overthere.ConnectionOptions;
import com.xebialabs.overthere.OperatingSystemFamily;
import com.xebialabs.overthere.OverthereProcess;
import com.xebialabs.overthere.RuntimeIOException;
import com.xebialabs.overthere.cifs.CifsConnection;
import com.xebialabs.overthere.cifs.CifsConnectionBuilder;
import com.xebialabs.overthere.cifs.WinrmHttpsCertificateTrustStrategy;
import com.xebialabs.overthere.cifs.WinrmHttpsHostnameVerificationStrategy;
import com.xebialabs.overthere.cifs.winrm.WinRmClient;
import com.xebialabs.overthere.cifs.winrm.WinRmRuntimeIOException;
import com.xebialabs.overthere.spi.AddressPortMapper;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CifsWinRmConnection
extends CifsConnection {
    private ConnectionOptions options;
    public static final int STDIN_BUF_SIZE = 4096;
    private static Logger logger = LoggerFactory.getLogger(CifsWinRmConnection.class);

    public CifsWinRmConnection(String type, ConnectionOptions options, AddressPortMapper mapper) {
        super(type, options, mapper, true);
        Preconditions.checkArgument((this.os == OperatingSystemFamily.WINDOWS ? 1 : 0) != 0, (String)"Cannot start a cifs:%s connection to a host that is not running Windows", (Object[])new Object[]{this.cifsConnectionType.toString().toLowerCase()});
        Preconditions.checkArgument((!this.username.contains("\\") ? 1 : 0) != 0, (String)"Cannot start a cifs:%s connection with an old-style Windows domain account [%s], use USER@DOMAIN instead.", (Object[])new Object[]{this.cifsConnectionType.toString().toLowerCase(), this.username});
        this.options = options;
    }

    @Override
    public OverthereProcess startProcess(CmdLine cmd) {
        Preconditions.checkNotNull((Object)cmd, (Object)"Cannot execute null command line");
        Preconditions.checkArgument((cmd.getArguments().size() > 0 ? 1 : 0) != 0, (Object)"Cannot execute empty command line");
        final String obfuscatedCmd = cmd.toCommandLine(this.os, true);
        logger.info("Starting command [{}] on [{}]", (Object)obfuscatedCmd, (Object)this);
        String cmdString = cmd.toCommandLine(this.os, false);
        if (this.workingDirectory != null) {
            cmdString = "CD /D " + this.workingDirectory.getPath() + " & " + cmdString;
        }
        final WinRmClient winRmClient = this.createWinrmClient();
        try {
            final PipedInputStream toCallersStdin = new PipedInputStream();
            final PipedOutputStream callersStdin = new PipedOutputStream(toCallersStdin);
            final PipedInputStream callersStdout = new PipedInputStream();
            final PipedOutputStream toCallersStdout = new PipedOutputStream(callersStdout);
            final PipedInputStream callersStderr = new PipedInputStream();
            final PipedOutputStream toCallersStderr = new PipedOutputStream(callersStderr);
            winRmClient.createShell();
            String commandId = winRmClient.executeCommand(cmdString);
            final Exception[] inputReaderTheaException = new Exception[1];
            Thread inputReaderThead = new Thread(String.format("WinRM input reader for command [%s]", commandId)){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        int n;
                        byte[] buf = new byte[4096];
                        while ((n = toCallersStdin.read(buf)) != -1) {
                            if (n == 0) continue;
                            byte[] bufToSend = new byte[n];
                            System.arraycopy(buf, 0, bufToSend, 0, n);
                            winRmClient.sendInput(bufToSend);
                        }
                    }
                    catch (Exception exc) {
                        inputReaderTheaException[0] = exc;
                    }
                    finally {
                        Closeables.closeQuietly((Closeable)callersStdin);
                    }
                }
            };
            inputReaderThead.setDaemon(true);
            inputReaderThead.start();
            final Exception[] outputReaderThreadException = new Exception[1];
            final Thread outputReaderThread = new Thread(String.format("WinRM output reader for command [%s]", commandId)){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        while (winRmClient.receiveOutput(toCallersStdout, toCallersStderr)) {
                        }
                    }
                    catch (Exception exc) {
                        outputReaderThreadException[0] = exc;
                    }
                    finally {
                        Closeables.closeQuietly((Closeable)toCallersStdout);
                        Closeables.closeQuietly((Closeable)toCallersStderr);
                    }
                }
            };
            outputReaderThread.setDaemon(true);
            outputReaderThread.start();
            return new OverthereProcess(){
                boolean processTerminated = false;

                @Override
                public synchronized OutputStream getStdin() {
                    return callersStdin;
                }

                @Override
                public synchronized InputStream getStdout() {
                    return callersStdout;
                }

                @Override
                public synchronized InputStream getStderr() {
                    return callersStderr;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public synchronized int waitFor() {
                    if (this.processTerminated) {
                        return this.exitValue();
                    }
                    try {
                        try {
                            outputReaderThread.join();
                        }
                        finally {
                            winRmClient.deleteShell();
                            this.processTerminated = true;
                        }
                        if (outputReaderThreadException[0] != null) {
                            if (outputReaderThreadException[0] instanceof RuntimeException) {
                                throw (RuntimeException)outputReaderThreadException[0];
                            }
                            throw new RuntimeIOException(String.format("Cannot execute command [%s] on [%s]", obfuscatedCmd, CifsWinRmConnection.this), outputReaderThreadException[0]);
                        }
                        return this.exitValue();
                    }
                    catch (InterruptedException exc) {
                        throw new RuntimeIOException(String.format("Cannot execute command [%s] on [%s]", obfuscatedCmd, CifsWinRmConnection.this), exc);
                    }
                }

                @Override
                public synchronized void destroy() {
                    if (this.processTerminated) {
                        return;
                    }
                    winRmClient.signal();
                    winRmClient.deleteShell();
                    this.processTerminated = true;
                }

                @Override
                public synchronized int exitValue() {
                    if (!this.processTerminated) {
                        throw new IllegalThreadStateException(String.format("Process for command [%s] on [%s] is still running", obfuscatedCmd, CifsWinRmConnection.this));
                    }
                    return winRmClient.exitValue();
                }
            };
        }
        catch (IOException exc) {
            throw new RuntimeIOException("Cannot execute command " + cmd + " on " + this, exc);
        }
    }

    private WinRmClient createWinrmClient() {
        WinRmClient client = new WinRmClient(this.username, this.password, this.createWinrmURL(), this.unmappedAddress, this.unmappedPort);
        client.setWinRmTimeout(this.options.get("winrmTimeout", "PT60.000S"));
        client.setWinRmEnvelopSize(this.options.get("winrmEnvelopSize", 153600));
        client.setWinRmLocale(this.options.get("winrmLocale", "en-US"));
        client.setHttpsCertTrustStrategy(this.options.getEnum("winrmHttpsCertificateTrustStrategy", WinrmHttpsCertificateTrustStrategy.class, CifsConnectionBuilder.DEFAULT_WINRM_HTTPS_CERTIFICATE_TRUST_STRATEGY));
        client.setHttpsHostnameVerifyStrategy(this.options.getEnum("winrmHttpsHostnameVerificationStrategy", WinrmHttpsHostnameVerificationStrategy.class, CifsConnectionBuilder.DEFAULT_WINRM_HTTPS_HOSTNAME_VERIFICATION_STRATEGY));
        client.setKerberosUseHttpSpn(this.options.getBoolean("winrmKerberosUseHttpSpn", false));
        client.setKerberosAddPortToSpn(this.options.getBoolean("winrmKerberosAddPortToSpn", false));
        client.setKerberosDebug(this.options.getBoolean("winrmKerberosDebug", false));
        return client;
    }

    private URL createWinrmURL() {
        String scheme = this.options.getBoolean("winrmEnableHttps", false) ? "https" : "http";
        String context = this.options.get("winrmContext", "/wsman");
        try {
            return new URL(scheme, this.address, this.port, context);
        }
        catch (MalformedURLException e) {
            throw new WinRmRuntimeIOException("Cannot build a new URL for " + this, e);
        }
    }
}

