/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.overthere.cifs.winrm;

import com.xebialabs.overthere.RuntimeIOException;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import org.dom4j.Document;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;

public class WinRmRuntimeIOException
extends RuntimeIOException {
    final Document in;
    final Document out;

    public WinRmRuntimeIOException(String message, Document in, Document out, Throwable cause) {
        super(message, cause);
        this.in = in;
        this.out = out;
    }

    public WinRmRuntimeIOException(String message) {
        this(message, null, null, null);
    }

    public WinRmRuntimeIOException(String message, Throwable throwable) {
        this(message, null, null, throwable);
    }

    @Override
    public String getMessage() {
        if (this.in == null && this.out == null) {
            return super.getMessage();
        }
        return String.format("%s\nRequest:\n%s\nResponse:\n%s", super.getMessage(), WinRmRuntimeIOException.toString(this.in), WinRmRuntimeIOException.toString(this.out));
    }

    private static String toString(Document doc) {
        if (doc == null) {
            return "[EMPTY]";
        }
        StringWriter stringWriter = new StringWriter();
        XMLWriter xmlWriter = new XMLWriter((Writer)stringWriter, OutputFormat.createPrettyPrint());
        try {
            xmlWriter.write(doc);
            xmlWriter.close();
        }
        catch (IOException e) {
            throw new RuntimeException("error ", e);
        }
        return stringWriter.toString();
    }
}

