/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.cache;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.jackrabbit.core.cache.AbstractCache;

public class ConcurrentCache<K, V>
extends AbstractCache {
    private static int DEFAULT_NUMBER_OF_SEGMENTS = Runtime.getRuntime().availableProcessors();
    private final String name;
    private final Map<K, E<V>>[] segments;

    public ConcurrentCache(String name, int numberOfSegments) {
        this.name = name;
        this.segments = new Map[numberOfSegments];
        for (int i = 0; i < this.segments.length; ++i) {
            this.segments[i] = new LinkedHashMap<K, E<V>>(16, 0.75f, true){

                @Override
                protected boolean removeEldestEntry(Map.Entry<K, E<V>> eldest) {
                    if (ConcurrentCache.this.isTooBig()) {
                        ConcurrentCache.this.recordSizeChange(-eldest.getValue().size);
                        return true;
                    }
                    return false;
                }
            };
        }
    }

    public ConcurrentCache(String name) {
        this(name, DEFAULT_NUMBER_OF_SEGMENTS);
    }

    private Map<K, E<V>> getSegment(K key) {
        return this.segments[(key.hashCode() >>> 1) % this.segments.length];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsKey(K key) {
        Map<K, E<E<V>>> segment;
        Map<K, E<E<V>>> map = segment = this.getSegment(key);
        synchronized (map) {
            return segment.containsKey(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V get(K key) {
        Map<K, E<E<V>>> segment;
        this.recordCacheAccess();
        Map<K, E<E<V>>> map = segment = this.getSegment(key);
        synchronized (map) {
            E<V> entry = segment.get(key);
            if (entry != null) {
                return (V)((E)entry).value;
            }
        }
        this.recordCacheMiss();
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<V> values() {
        ArrayList<Object> values = new ArrayList<Object>();
        for (int i = 0; i < this.segments.length; ++i) {
            Map<K, E<V>> map = this.segments[i];
            synchronized (map) {
                for (E<V> entry : this.segments[i].values()) {
                    values.add(((E)entry).value);
                }
                continue;
            }
        }
        return values;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V put(K key, V value, long size) {
        E<V> previous;
        Map<K, E<E<E<E<V>>>>> segment;
        Map<K, E<E<E<E<V>>>>> map = segment = this.getSegment(key);
        synchronized (map) {
            this.recordSizeChange(size);
            previous = segment.put(key, new E<V>(value, size));
        }
        if (previous != null) {
            this.recordSizeChange(-((E)previous).size);
            this.shrinkIfNeeded();
            return (V)((E)previous).value;
        }
        this.shrinkIfNeeded();
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V remove(K key) {
        Map<K, E<E<V>>> segment;
        Map<K, E<E<V>>> map = segment = this.getSegment(key);
        synchronized (map) {
            E<V> entry = segment.remove(key);
            if (entry != null) {
                this.recordSizeChange(-((E)entry).size);
                return (V)((E)entry).value;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        for (int i = 0; i < this.segments.length; ++i) {
            Map<K, E<V>> map = this.segments[i];
            synchronized (map) {
                for (E<V> entry : this.segments[i].values()) {
                    this.recordSizeChange(-((E)entry).size);
                }
                this.segments[i].clear();
                continue;
            }
        }
    }

    public boolean isEmpty() {
        return this.getMemoryUsed() == 0L;
    }

    @Override
    public void setMaxMemorySize(long size) {
        super.setMaxMemorySize(size);
        this.shrinkIfNeeded();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void shrinkIfNeeded() {
        int start;
        int i = start = (int)Math.abs(this.getAccessCount() % (long)this.segments.length);
        while (this.isTooBig()) {
            Map<K, E<V>> map = this.segments[i];
            synchronized (map) {
                Iterator<Map.Entry<K, E<V>>> iterator = this.segments[i].entrySet().iterator();
                if (iterator.hasNext()) {
                    Map.Entry<K, E<V>> entry = iterator.next();
                    this.segments[i].remove(entry.getKey());
                    this.segments[i].put(entry.getKey(), entry.getValue());
                }
            }
            i = (i + 1) % this.segments.length;
        }
    }

    @Override
    public long getElementCount() {
        long count = 0L;
        for (int i = 0; i < this.segments.length; ++i) {
            count += (long)this.segments[i].size();
        }
        return count;
    }

    public String toString() {
        return this.name + "[" + this.getClass().getSimpleName() + "@" + Integer.toHexString(this.hashCode()) + "]";
    }

    private static class E<V> {
        private final V value;
        private final long size;

        public E(V value, long size) {
            this.value = value;
            this.size = size;
        }
    }
}

